/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.plugin.storage.provider.s3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Set;

public final class S3Util
extends Enum<S3Util> {
    private static final Set<String> S3_SCHEMES;
    private static final /* synthetic */ S3Util[] $VALUES;

    public static S3Util[] values() {
        return (S3Util[])$VALUES.clone();
    }

    public static S3Util valueOf(String name) {
        return Enum.valueOf(S3Util.class, name);
    }

    public static URI formatS3Uri(URI uri) {
        if (Objects.nonNull(uri.getScheme()) && S3_SCHEMES.contains(uri.getScheme())) {
            return uri;
        }
        try {
            return new URI("s3", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Format s3 uri failed, uri: %s", uri), e);
        }
    }

    private static /* synthetic */ S3Util[] $values() {
        return new S3Util[0];
    }

    static {
        $VALUES = S3Util.$values();
        S3_SCHEMES = Set.of("s3", "s3a");
    }
}

