/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.example.redisson.service;

import cn.sliew.carp.example.redisson.service.job.EchoCallable;
import cn.sliew.carp.example.redisson.service.job.EchoRunner;
import cn.sliew.carp.example.redisson.service.listener.TaskFailureListenerImpl;
import cn.sliew.carp.example.redisson.service.listener.TaskFinishedListenerImpl;
import cn.sliew.carp.example.redisson.service.listener.TaskStartedListenerImpl;
import cn.sliew.carp.example.redisson.service.listener.TaskSuccessListenerImpl;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.CronSchedule;
import org.redisson.api.RExecutorFuture;
import org.redisson.api.RScheduledExecutorService;
import org.redisson.api.RScheduledFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.WorkerOptions;
import org.redisson.api.executor.TaskListener;
import org.redisson.api.options.ExecutorOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributedExecutorService
implements InitializingBean,
BeanFactoryAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistributedExecutorService.class);
    @Autowired
    private RedissonClient client;
    private BeanFactory beanFactory;
    private RScheduledExecutorService executorService;

    public void afterPropertiesSet() throws Exception {
        ExecutorOptions executorOptions = ExecutorOptions.name((String)"");
        this.executorService = this.client.getExecutorService(executorOptions);
        WorkerOptions workerOptions = WorkerOptions.defaults().workers(2).beanFactory(this.beanFactory).taskTimeout(60L, TimeUnit.SECONDS).addListener((TaskListener)new TaskSuccessListenerImpl()).addListener((TaskListener)new TaskFailureListenerImpl()).addListener((TaskListener)new TaskStartedListenerImpl()).addListener((TaskListener)new TaskFinishedListenerImpl());
        this.executorService.registerWorkers(workerOptions);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Boolean cancel(String taskId) {
        return this.executorService.cancelTask(taskId);
    }

    public String submitCallable(String input) throws ExecutionException, InterruptedException {
        RExecutorFuture future = this.executorService.submit((Callable)new EchoCallable(input));
        String taskId = future.getTaskId();
        future.toCompletableFuture().whenComplete((result, throwable) -> log.info("\u5f02\u6b65\u6267\u884c, taskId: {}, input: {}, result: {}", new Object[]{taskId, input, result}));
        return (String)future.get();
    }

    public void scheduleRunnable(String input) {
        RScheduledFuture future = this.executorService.scheduleWithFixedDelay((Runnable)new EchoRunner(input), 0L, 10L, TimeUnit.SECONDS);
        String taskId = future.getTaskId();
        future.toCompletableFuture().whenComplete((result, throwable) -> log.info("\u5f02\u6b65\u6267\u884c, taskId: {}, input: {}, result: {}", new Object[]{taskId, input, result}));
    }

    public void scheduleLambda(String input) {
        RScheduledFuture future = this.executorService.scheduleWithFixedDelay((Runnable & Serializable)() -> log.info("execute"), 0L, 10L, TimeUnit.SECONDS);
        String taskId = future.getTaskId();
        future.toCompletableFuture().whenComplete((result, throwable) -> log.info("\u5f02\u6b65\u6267\u884c, taskId: {}, input: {}, result: {}", new Object[]{taskId, input, result}));
    }

    public void scheduleRunnableWithCron(String input) {
        RScheduledFuture future = this.executorService.schedule((Runnable)new EchoRunner(input), CronSchedule.of((String)"0/10 * * * * ?"));
        String taskId = future.getTaskId();
        future.toCompletableFuture().whenComplete((result, throwable) -> log.info("\u5f02\u6b65\u6267\u884c, taskId: {}, input: {}, result: {}", new Object[]{taskId, input, result}));
    }
}

