/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.example.redisson.controller;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.thread.ThreadUtil;
import cn.sliew.carp.example.redisson.service.LockService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carp/example/redisson/lock"})
@Tag(name="\u6d4b\u8bd5\u6a21\u5757-Lock")
public class LockController {
    @Autowired
    private LockService lockService;

    @PostMapping(value={"/lock-unlock"})
    @Operation(summary="\u52a0\u9501-\u91ca\u653e\u9501")
    public String lockAndUnlock() throws Exception {
        String key = UUID.fastUUID().toString(true);
        boolean locked = this.lockService.lockWithAutoRefreshTTL(key, Duration.ofSeconds(3L).toMillis());
        if (locked) {
            System.out.println("lock: " + key);
            ThreadUtil.sleep((long)Duration.ofMinutes(3L).toMillis());
            Long releaseTime = this.lockService.lockReleaseTime(key);
            System.out.println("lock relase time: " + DurationFormatUtils.formatDurationHMS((long)releaseTime));
            this.lockService.unlock(key);
            return key;
        }
        return "\u52a0\u9501\u5931\u8d25";
    }

    @PostMapping(value={"/lock-unlock-async"})
    @Operation(summary="\u52a0\u9501-\u5f02\u6b65\u91ca\u653e\u9501")
    public String lockAndUnlockAsync() throws Exception {
        String key = UUID.fastUUID().toString(true);
        boolean locked = this.lockService.lockWithAutoRefreshTTL(key, Duration.ofSeconds(3L).toMillis());
        if (locked) {
            ThreadPoolExecutor executor = ThreadUtil.newExecutor((int)4);
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                System.out.println("lock: " + key);
                ThreadUtil.sleep((long)Duration.ofMinutes(1L).toMillis());
                Long releaseTime = this.lockService.lockReleaseTime(key);
                System.out.println("lock relase time: " + DurationFormatUtils.formatDurationHMS((long)releaseTime));
            }, executor);
            future.whenCompleteAsync((unused, throwable) -> this.lockService.forceUnlock(key), (Executor)executor);
            return key;
        }
        return "\u52a0\u9501\u5931\u8d25";
    }

    @PostMapping(value={"/lock"})
    @Operation(summary="\u52a0\u9501")
    public String lock() throws Exception {
        String key = UUID.fastUUID().toString(true);
        boolean locked = this.lockService.lock(key, Duration.ofSeconds(3L).toMillis(), Duration.ofSeconds(10L).toMillis());
        if (locked) {
            return key;
        }
        return "\u52a0\u9501\u5931\u8d25";
    }

    @PostMapping(value={"/unlock"})
    @Operation(summary="\u91ca\u653e\u9501")
    public void unlock(@RequestParam(value="key") String key) throws Exception {
        this.lockService.unlock(key);
    }

    @PostMapping(value={"/forceUnlock"})
    @Operation(summary="\u5f3a\u5236\u91ca\u653e\u9501")
    public void forceUnlock(@RequestParam(value="key") String key) throws Exception {
        this.lockService.forceUnlock(key);
    }

    @GetMapping(value={"/lock-ttl"})
    @Operation(summary="\u9501\u91ca\u653e\u65f6\u95f4")
    public String scheduleLambda(@RequestParam(value="key") String key) throws Exception {
        Long time = this.lockService.lockReleaseTime(key);
        return DurationFormatUtils.formatDurationHMS((long)time);
    }
}

