/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.example.redisson.service;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LockService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LockService.class);
    @Value(value="${spring.application.name}")
    private String application;
    @Autowired
    private RedissonClient client;

    public boolean lock(String key, long lockTimeout, long releaseTime) {
        RLock lock = this.getLock(key);
        try {
            return lock.tryLock(lockTimeout, releaseTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean lockWithAutoRefreshTTL(String key, long lockTimeout) {
        RLock lock = this.getLock(key);
        try {
            return lock.tryLock(lockTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Long lockReleaseTime(String key) {
        RLock lock = this.getLock(key);
        if (lock.isLocked()) {
            return lock.remainTimeToLive();
        }
        return 0L;
    }

    public void unlock(String key) {
        RLock lock = this.getLock(key);
        try {
            if (lock.isLocked()) {
                lock.unlock();
            }
        }
        catch (Exception e) {
            log.error("unlock failed, lock: {}", (Object)lock.getName(), (Object)e);
        }
    }

    public void forceUnlock(String key) {
        RLock lock = this.getLock(key);
        try {
            if (lock.isLocked()) {
                lock.forceUnlock();
            }
        }
        catch (Exception e) {
            log.error("forceUnlock failed, lock: {}", (Object)lock.getName(), (Object)e);
        }
    }

    private RLock getLock(String key) {
        return this.client.getLock(this.appendLockKey(key));
    }

    private String appendLockKey(String key) {
        return String.format("%s:lock:%s", this.application, key);
    }
}

