/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.io.stream;

import cn.sliew.milky.common.io.stream.Writable;
import cn.sliew.milky.common.util.BitUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class StreamOutput
extends OutputStream {
    private static final ThreadLocal<byte[]> scratch = ThreadLocal.withInitial(() -> new byte[1024]);
    private static byte ZERO = 0;
    private static byte ONE = 1;
    private static byte TWO = (byte)2;
    private static final Map<Class<?>, Writable.Writer> WRITERS;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract void flush() throws IOException;

    public abstract void reset() throws IOException;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public final void writeShort(short v) throws IOException {
        byte[] buffer = scratch.get();
        buffer[0] = (byte)(v >> 8);
        buffer[1] = (byte)v;
        this.writeBytes(buffer, 0, 2);
    }

    public void writeInt(int i) throws IOException {
        byte[] buffer = scratch.get();
        buffer[0] = (byte)(i >> 24);
        buffer[1] = (byte)(i >> 16);
        buffer[2] = (byte)(i >> 8);
        buffer[3] = (byte)i;
        this.writeBytes(buffer, 0, 4);
    }

    public void writeOptionalInt(Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeInt(integer);
        }
    }

    public void writeVInt(int i) throws IOException {
        if (Integer.numberOfLeadingZeros(i) >= 25) {
            this.writeByte((byte)i);
            return;
        }
        byte[] buffer = scratch.get();
        int index = 0;
        do {
            buffer[index++] = (byte)(i & 0x7F | 0x80);
        } while (((i >>>= 7) & 0xFFFFFF80) != 0);
        buffer[index++] = (byte)i;
        this.writeBytes(buffer, 0, index);
    }

    public void writeOptionalVInt(Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVInt(integer);
        }
    }

    public void writeLong(long i) throws IOException {
        byte[] buffer = scratch.get();
        buffer[0] = (byte)(i >> 56);
        buffer[1] = (byte)(i >> 48);
        buffer[2] = (byte)(i >> 40);
        buffer[3] = (byte)(i >> 32);
        buffer[4] = (byte)(i >> 24);
        buffer[5] = (byte)(i >> 16);
        buffer[6] = (byte)(i >> 8);
        buffer[7] = (byte)i;
        this.writeBytes(buffer, 0, 8);
    }

    public void writeOptionalLong(Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeLong(l);
        }
    }

    public void writeVLong(long i) throws IOException {
        if (i < 0L) {
            throw new IllegalStateException("Negative longs unsupported, use writeLong or writeZLong for negative numbers [" + i + "]");
        }
        this.writeVLongNoCheck(i);
    }

    public void writeOptionalVLong(Long l) throws IOException {
        if (l == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVLong(l);
        }
    }

    public void writeZLong(long i) throws IOException {
        byte[] buffer = scratch.get();
        int index = 0;
        long value = BitUtil.zigZagEncode(i);
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(value & 0x7FL | 0x80L);
            value >>>= 7;
        }
        buffer[index++] = (byte)(value & 0x7FL);
        this.writeBytes(buffer, 0, index);
    }

    void writeVLongNoCheck(long i) throws IOException {
        byte[] buffer = scratch.get();
        int index = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer[index++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        buffer[index++] = (byte)i;
        this.writeBytes(buffer, 0, index);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeOptionalFloat(Float floatValue) throws IOException {
        if (floatValue == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeFloat(floatValue.floatValue());
        }
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeOptionalDouble(Double v) throws IOException {
        if (v == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeDouble(v);
        }
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    public void writeOptionalBoolean(Boolean b) throws IOException {
        if (b == null) {
            this.writeByte(TWO);
        } else {
            this.writeBoolean(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeGenericValue(Object value) throws IOException {
        if (value == null) {
            this.writeByte((byte)-1);
            return;
        }
        Writable.Writer writer = WRITERS.get(value.getClass());
        if (writer == null) {
            throw new IllegalArgumentException("can not write type [" + value.getClass() + "]");
        }
        writer.write(this, value);
    }

    static {
        HashMap<Class<Boolean>, Writable.Writer<Object>> writers = new HashMap<Class<Boolean>, Writable.Writer<Object>>();
        writers.put(Byte.class, (o, v) -> {
            o.writeByte((byte)0);
            o.writeByte((Byte)v);
        });
        writers.put(Short.class, (o, v) -> {
            o.writeByte((byte)1);
            o.writeShort((Short)v);
        });
        writers.put(Integer.class, (o, v) -> {
            o.writeByte((byte)2);
            o.writeInt((Integer)v);
        });
        writers.put(Long.class, (o, v) -> {
            o.writeByte((byte)3);
            o.writeLong((Long)v);
        });
        writers.put(Float.class, (o, v) -> {
            o.writeByte((byte)4);
            o.writeFloat(((Float)v).floatValue());
        });
        writers.put(Double.class, (o, v) -> {
            o.writeByte((byte)5);
            o.writeDouble((Double)v);
        });
        writers.put(Boolean.class, (o, v) -> {
            o.writeByte((byte)6);
            o.writeBoolean((Boolean)v);
        });
        WRITERS = Collections.unmodifiableMap(writers);
    }
}

