/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.common.enums;

import cn.sliew.flinkful.common.enums.DeploymentMode;
import cn.sliew.flinkful.common.enums.ResourceProvider;
import lombok.Generated;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;

public enum DeploymentTarget {
    STANDALONE_APPLICATION(0, ResourceProvider.STANDALONE, DeploymentMode.APPLICATION, "remote"),
    STANDALONE_SESSION(1, ResourceProvider.STANDALONE, DeploymentMode.SESSION, "remote"),
    NATIVE_KUBERNETES_APPLICATION(2, ResourceProvider.NATIVE_KUBERNETES, DeploymentMode.APPLICATION, KubernetesDeploymentTarget.APPLICATION.getName()),
    NATIVE_KUBERNETES_SESSION(3, ResourceProvider.NATIVE_KUBERNETES, DeploymentMode.SESSION, KubernetesDeploymentTarget.SESSION.getName());

    private int code;
    private ResourceProvider resourceProvider;
    private DeploymentMode deploymentMode;
    private String name;

    private DeploymentTarget(int code, ResourceProvider resourceProvider, DeploymentMode deploymentMode, String name) {
        this.code = code;
        this.resourceProvider = resourceProvider;
        this.deploymentMode = deploymentMode;
        this.name = name;
    }

    public void apply(Configuration configuration) {
        configuration.set(DeploymentOptions.TARGET, (Object)this.getName());
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Generated
    public DeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

