/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.sakura;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.flinkful.sql.catalog.dict.CatalogType;
import cn.sliew.flinkful.sql.catalog.sakura.factory.CatalogDatabaseFactory;
import cn.sliew.flinkful.sql.catalog.sakura.factory.CatalogFunctionFactory;
import cn.sliew.flinkful.sql.catalog.sakura.factory.CatalogTableFactory;
import cn.sliew.flinkful.sql.catalog.sakura.factory.CatalogViewFactory;
import cn.sliew.flinkful.sql.catalog.service.FlinkfulCatalogService;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogDatabaseDTO;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogFunctionDTO;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogTableDTO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;

public class SakuraCatalog
extends AbstractCatalog {
    private FlinkfulCatalogService catalogService;

    public SakuraCatalog(String name) {
        super(name, "sakura");
    }

    public void open() throws CatalogException {
        this.catalogService = (FlinkfulCatalogService)SpringUtil.getBean(FlinkfulCatalogService.class);
    }

    public void close() throws CatalogException {
    }

    public List<String> listDatabases() throws CatalogException {
        return this.catalogService.listDatabases(CatalogType.FLINK, this.getName()).stream().map(CatalogDatabaseDTO::getName).sorted().collect(Collectors.toList());
    }

    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException, CatalogException {
        Optional<CatalogDatabaseDTO> optional = this.catalogService.getDatabase(CatalogType.FLINK, this.getName(), databaseName);
        return optional.map(CatalogDatabaseFactory::toDatabase).orElseThrow(() -> new DatabaseNotExistException(this.getName(), databaseName));
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        return this.catalogService.databaseExists(CatalogType.FLINK, this.getName(), databaseName);
    }

    public void createDatabase(String name, CatalogDatabase database, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        CatalogDatabaseDTO databaseDTO = CatalogDatabaseFactory.fromDatabase(this.getName(), name, database);
        this.catalogService.insertDatabase(databaseDTO);
    }

    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException, CatalogException {
        block4: {
            if (!this.databaseExists(name) && !ignoreIfNotExists) {
                throw new DatabaseNotExistException(this.getName(), name);
            }
            if (!cascade && !this.catalogService.isDatabaseEmpty(CatalogType.FLINK, this.getName(), name)) {
                throw new DatabaseNotEmptyException(this.getName(), name);
            }
            try {
                this.listTables(name).forEach(tableName -> {
                    try {
                        this.dropTable(new ObjectPath(this.getName(), tableName), true);
                    }
                    catch (TableNotExistException tableNotExistException) {
                        // empty catch block
                    }
                });
                this.listFunctions(name).forEach(tableName -> {
                    try {
                        this.dropFunction(new ObjectPath(this.getName(), tableName), true);
                    }
                    catch (FunctionNotExistException functionNotExistException) {
                        // empty catch block
                    }
                });
                this.catalogService.deleteDatabase(CatalogType.FLINK, this.getName(), name);
            }
            catch (DatabaseNotExistException e) {
                if (ignoreIfNotExists) break block4;
                throw e;
            }
        }
    }

    public void alterDatabase(String name, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        CatalogDatabaseDTO catalogDatabaseDTO = CatalogDatabaseFactory.fromDatabase(this.getName(), name, newDatabase);
        this.catalogService.updateDatabase(catalogDatabaseDTO);
    }

    public List<String> listTables(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.catalogService.listTables(CatalogType.FLINK, this.getName(), databaseName).stream().map(CatalogTableDTO::getName).collect(Collectors.toList());
    }

    public List<String> listViews(String databaseName) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.catalogService.listViews(CatalogType.FLINK, this.getName(), databaseName).stream().map(CatalogTableDTO::getName).collect(Collectors.toList());
    }

    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        String database = tablePath.getDatabaseName();
        String table = tablePath.getObjectName();
        Optional<CatalogBaseTable> tableOptional = this.catalogService.getTable(CatalogType.FLINK, this.getName(), database, table).map(CatalogTableFactory::toTable);
        Optional<CatalogBaseTable> viewOptional = this.catalogService.getView(CatalogType.FLINK, this.getName(), database, table).map(CatalogViewFactory::toView);
        return tableOptional.or(() -> viewOptional).orElseThrow(() -> new TableNotExistException(this.getName(), tablePath));
    }

    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        String database = tablePath.getDatabaseName();
        String table = tablePath.getObjectName();
        boolean tableExists = this.catalogService.tableExists(CatalogType.FLINK, this.getName(), database, table);
        boolean viewExists = this.catalogService.viewExists(CatalogType.FLINK, this.getName(), database, table);
        return tableExists || viewExists;
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        block6: {
            String database = tablePath.getDatabaseName();
            String table = tablePath.getObjectName();
            try {
                CatalogBaseTable object = this.getTable(tablePath);
                switch (object.getTableKind()) {
                    case TABLE: {
                        this.catalogService.deleteTable(CatalogType.FLINK, this.getName(), database, table);
                        break;
                    }
                    case VIEW: {
                        this.catalogService.deleteView(CatalogType.FLINK, this.getName(), database, table);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown table type: " + String.valueOf(object.getTableKind()));
                    }
                }
            }
            catch (TableNotExistException e) {
                if (ignoreIfNotExists) break block6;
                throw e;
            }
        }
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException, CatalogException {
        block6: {
            String database = tablePath.getDatabaseName();
            String table = tablePath.getObjectName();
            try {
                CatalogBaseTable object = this.getTable(tablePath);
                switch (object.getTableKind()) {
                    case TABLE: {
                        this.catalogService.renameTable(CatalogType.FLINK, this.getName(), database, table, newTableName);
                        break;
                    }
                    case VIEW: {
                        this.catalogService.renameView(CatalogType.FLINK, this.getName(), database, table, newTableName);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown table type: " + String.valueOf(object.getTableKind()));
                    }
                }
            }
            catch (TableNotExistException e) {
                if (ignoreIfNotExists) break block6;
                throw e;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void createTable(ObjectPath tablePath, CatalogBaseTable catalogBaseTable, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        database = tablePath.getDatabaseName();
        table = tablePath.getObjectName();
        switch (1.$SwitchMap$org$apache$flink$table$catalog$CatalogBaseTable$TableKind[catalogBaseTable.getTableKind().ordinal()]) {
            case 1: {
                catalogTable = (CatalogTable)catalogBaseTable;
                catalogTableDTO = CatalogTableFactory.fromResolvedTable(table, (CatalogBaseTable)catalogTable);
                try {
                    this.catalogService.insertTable(CatalogType.FLINK, this.getName(), database, catalogTableDTO);
                    break;
                }
                catch (TableAlreadyExistException e) {
                    if (ignoreIfExists) ** GOTO lbl13
                    throw e;
                }
            }
lbl13:
            // 2 sources

            case 2: {
                catalogView = (ResolvedCatalogView)catalogBaseTable;
                catalogViewDTO = CatalogViewFactory.fromResolvedView(table, catalogView);
                try {
                    this.catalogService.insertView(CatalogType.FLINK, this.getName(), database, catalogViewDTO);
                    break;
                }
                catch (TableAlreadyExistException e) {
                    if (ignoreIfExists) break;
                    throw e;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown table type: " + String.valueOf(catalogBaseTable.getTableKind()));
            }
        }
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        block7: {
            String database = tablePath.getDatabaseName();
            String table = tablePath.getObjectName();
            try {
                CatalogBaseTable currentTable = this.getTable(tablePath);
                if (currentTable.getTableKind() != newTable.getTableKind()) {
                    throw new IllegalArgumentException("Cannot convert between TABLE and VIEW.");
                }
                switch (currentTable.getTableKind()) {
                    case TABLE: {
                        CatalogTable catalogTable = (CatalogTable)newTable;
                        CatalogTableDTO catalogTableDTO = CatalogTableFactory.fromResolvedTable(table, (CatalogBaseTable)catalogTable);
                        this.catalogService.updateTable(CatalogType.FLINK, this.getName(), database, catalogTableDTO);
                        break;
                    }
                    case VIEW: {
                        ResolvedCatalogView catalogView = (ResolvedCatalogView)newTable;
                        CatalogTableDTO catalogViewDTO = CatalogViewFactory.fromResolvedView(table, catalogView);
                        this.catalogService.updateView(CatalogType.FLINK, this.getName(), database, catalogViewDTO);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown table type: " + String.valueOf(currentTable.getTableKind()));
                    }
                }
            }
            catch (TableNotExistException e) {
                if (ignoreIfNotExists) break block7;
                throw e;
            }
        }
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        throw new TableNotPartitionedException(this.getName(), tablePath);
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        throw new TableNotPartitionedException(this.getName(), tablePath);
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        throw new TableNotPartitionedException(this.getName(), tablePath);
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        throw new TableNotPartitionedException(this.getName(), tablePath);
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
    }

    public List<String> listFunctions(String dbName) throws DatabaseNotExistException, CatalogException {
        if (!this.databaseExists(dbName)) {
            throw new DatabaseNotExistException(this.getName(), dbName);
        }
        return this.catalogService.listFunctions(CatalogType.FLINK, this.getName(), dbName).stream().map(CatalogFunctionDTO::getName).collect(Collectors.toList());
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        String database = functionPath.getDatabaseName();
        String function = functionPath.getObjectName();
        return this.catalogService.getFunction(CatalogType.FLINK, this.getName(), database, function).map(CatalogFunctionFactory::toCatalogFunction).orElseThrow(() -> new FunctionNotExistException(this.getName(), functionPath));
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        String database = functionPath.getDatabaseName();
        String function = functionPath.getObjectName();
        return this.catalogService.functionExists(CatalogType.FLINK, this.getName(), database, function);
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException, CatalogException {
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws FunctionNotExistException, CatalogException {
        block2: {
            String database = functionPath.getDatabaseName();
            String function = functionPath.getObjectName();
            try {
                this.catalogService.deleteFunction(CatalogType.FLINK, this.getName(), database, function);
            }
            catch (FunctionNotExistException e) {
                if (ignoreIfNotExists) break block2;
                throw e;
            }
        }
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        if (!this.tableExists(tablePath) && !ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        throw new CatalogException("SakuraCatalog not support table statistics yet.");
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException, TablePartitionedException {
        if (!this.tableExists(tablePath) && !ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        throw new CatalogException("SakuraCatalog not support table column statistics yet.");
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        if (!this.partitionExists(tablePath, partitionSpec) && !ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        throw new CatalogException("SakuraCatalog not support partition statistics yet.");
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        if (!this.partitionExists(tablePath, partitionSpec) && !ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        throw new CatalogException("SakuraCatalog not support partition column statistics yet.");
    }
}

