/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.service.convert;

import cn.sliew.carp.framework.common.codec.CodecUtil;
import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.flinkful.sql.catalog.repository.entity.CatalogDatabase;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogDatabaseDTO;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface CatalogDatabaseConvert
extends BaseConvert<CatalogDatabase, CatalogDatabaseDTO> {
    public static final CatalogDatabaseConvert INSTANCE = (CatalogDatabaseConvert)Mappers.getMapper(CatalogDatabaseConvert.class);

    default public CatalogDatabase toDo(CatalogDatabaseDTO dto) {
        try {
            CatalogDatabase entity = new CatalogDatabase();
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
            entity.setCatalog(dto.getCatalog());
            entity.setName(dto.getName());
            entity.setRemark(dto.getRemark());
            if (dto.getProperties() != null) {
                entity.setProperties(CodecUtil.encrypt((String)JacksonUtil.toJsonString(dto.getProperties())));
            }
            return entity;
        }
        catch (Exception e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }

    default public CatalogDatabaseDTO toDto(CatalogDatabase entity) {
        try {
            CatalogDatabaseDTO dto = new CatalogDatabaseDTO();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
            dto.setCatalog(entity.getCatalog());
            dto.setName(entity.getName());
            dto.setRemark(entity.getRemark());
            if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getProperties())) {
                Map properties = (Map)JacksonUtil.parseJsonString((String)CodecUtil.decrypt((String)entity.getProperties()), (TypeReference)new TypeReference<Map<String, String>>(){});
                dto.setProperties(properties);
            }
            return dto;
        }
        catch (Exception e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }
}

