/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.service.convert;

import cn.sliew.carp.framework.common.codec.CodecUtil;
import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.flinkful.sql.catalog.repository.entity.CatalogTable;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogTableDTO;
import cn.sliew.flinkful.sql.catalog.service.dto.SchemaDTO;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface CatalogTableConvert
extends BaseConvert<CatalogTable, CatalogTableDTO> {
    public static final CatalogTableConvert INSTANCE = (CatalogTableConvert)Mappers.getMapper(CatalogTableConvert.class);

    default public CatalogTable toDo(CatalogTableDTO dto) {
        try {
            CatalogTable entity = new CatalogTable();
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
            entity.setKind(dto.getKind());
            entity.setName(dto.getName());
            if (dto.getSchema() != null) {
                entity.setSchema(JacksonUtil.toJsonString((Object)dto.getSchema()));
            }
            entity.setOriginalQuery(dto.getOriginalQuery());
            entity.setExpandedQuery(dto.getExpandedQuery());
            entity.setRemark(dto.getRemark());
            if (dto.getProperties() != null) {
                entity.setProperties(CodecUtil.encrypt((String)JacksonUtil.toJsonString(dto.getProperties())));
            }
            return entity;
        }
        catch (Exception e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }

    default public CatalogTableDTO toDto(CatalogTable entity) {
        try {
            CatalogTableDTO dto = new CatalogTableDTO();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
            dto.setKind(entity.getKind());
            dto.setName(entity.getName());
            if (StringUtils.isNotBlank((CharSequence)entity.getSchema())) {
                dto.setSchema((SchemaDTO)JacksonUtil.parseJsonString((String)entity.getSchema(), SchemaDTO.class));
            }
            dto.setOriginalQuery(entity.getOriginalQuery());
            dto.setExpandedQuery(entity.getExpandedQuery());
            dto.setRemark(entity.getRemark());
            if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getProperties())) {
                Map properties = (Map)JacksonUtil.parseJsonString((String)CodecUtil.decrypt((String)entity.getProperties()), (TypeReference)new TypeReference<Map<String, String>>(){});
                dto.setProperties(properties);
            }
            return dto;
        }
        catch (Exception e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }
}

