/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.store;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.flinkful.sql.catalog.dict.CatalogType;
import cn.sliew.flinkful.sql.catalog.service.FlinkfulCatalogStoreService;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogStoreDTO;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.AbstractCatalogStore;
import org.apache.flink.table.catalog.CatalogDescriptor;
import org.apache.flink.table.catalog.exceptions.CatalogException;

public class JdbcCatalogStore
extends AbstractCatalogStore {
    private FlinkfulCatalogStoreService catalogStoreService;

    public void open() {
        super.open();
        this.catalogStoreService = (FlinkfulCatalogStoreService)SpringUtil.getBean(FlinkfulCatalogStoreService.class);
    }

    public void storeCatalog(String catalogName, CatalogDescriptor catalog) throws CatalogException {
        CatalogStoreDTO dto = new CatalogStoreDTO();
        dto.setType(CatalogType.FLINK);
        dto.setCatalogName(catalog.getCatalogName());
        dto.setConfiguration(catalog.getConfiguration());
        if (this.contains(catalogName)) {
            this.catalogStoreService.update(dto);
        } else {
            this.catalogStoreService.add(dto);
        }
    }

    public void removeCatalog(String catalogName, boolean ignoreIfNotExists) throws CatalogException {
        if (!this.contains(catalogName) && !ignoreIfNotExists) {
            throw new CatalogException(String.format("Catalog %s's store is not exist", catalogName));
        }
        this.catalogStoreService.delete(CatalogType.FLINK, catalogName);
    }

    public Optional<CatalogDescriptor> getCatalog(String catalogName) throws CatalogException {
        return this.catalogStoreService.get(CatalogType.FLINK, catalogName).map(dto -> CatalogDescriptor.of((String)dto.getCatalogName(), (Configuration)dto.getConfiguration()));
    }

    public Set<String> listCatalogs() throws CatalogException {
        return this.catalogStoreService.list(CatalogType.FLINK).stream().map(CatalogStoreDTO::getCatalogName).collect(Collectors.toSet());
    }

    public boolean contains(String catalogName) throws CatalogException {
        return this.getCatalog(catalogName).isPresent();
    }
}

