/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.store;

import cn.hutool.extra.spring.SpringUtil;
import cn.sliew.flinkful.sql.catalog.store.JdbcCatalogStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.springframework.context.ApplicationContext;

public class JdbcCatalogStoreFactory
implements CatalogStoreFactory {
    public CatalogStore createCatalogStore() {
        return new JdbcCatalogStore();
    }

    public void open(CatalogStoreFactory.Context context) throws CatalogException {
        ApplicationContext applicationContext = SpringUtil.getApplicationContext();
        if (Objects.isNull(applicationContext)) {
            throw new CatalogException("Lack spring application context unable to open JdbcCatalogStore.");
        }
        CatalogStoreFactoryHelper factoryHelper = new CatalogStoreFactoryHelper(this, context);
        factoryHelper.validate();
        ReadableConfig options = factoryHelper.getOptions();
    }

    public void close() throws CatalogException {
    }

    public String factoryIdentifier() {
        return "jdbc";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public static class CatalogStoreFactoryHelper
    extends FactoryUtil.FactoryHelper<CatalogStoreFactory> {
        public CatalogStoreFactoryHelper(CatalogStoreFactory catalogStoreFactory, CatalogStoreFactory.Context context) {
            super((Factory)catalogStoreFactory, context.getOptions(), new ConfigOption[]{FactoryUtil.PROPERTY_VERSION});
        }
    }
}

