/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.service.impl;

import cn.sliew.flinkful.sql.catalog.dict.CatalogType;
import cn.sliew.flinkful.sql.catalog.dict.flink.CatalogTableKind;
import cn.sliew.flinkful.sql.catalog.repository.entity.CatalogDatabase;
import cn.sliew.flinkful.sql.catalog.repository.entity.CatalogFunction;
import cn.sliew.flinkful.sql.catalog.repository.entity.CatalogTable;
import cn.sliew.flinkful.sql.catalog.repository.mapper.CatalogDatabaseMapper;
import cn.sliew.flinkful.sql.catalog.repository.mapper.CatalogFunctionMapper;
import cn.sliew.flinkful.sql.catalog.repository.mapper.CatalogTableMapper;
import cn.sliew.flinkful.sql.catalog.service.FlinkfulCatalogService;
import cn.sliew.flinkful.sql.catalog.service.convert.CatalogDatabaseConvert;
import cn.sliew.flinkful.sql.catalog.service.convert.CatalogFunctionConvert;
import cn.sliew.flinkful.sql.catalog.service.convert.CatalogTableConvert;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogDatabaseDTO;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogFunctionDTO;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogTableDTO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.springframework.stereotype.Service;

@Service
public class FlinkfulCatalogServiceImpl
implements FlinkfulCatalogService {
    private final CatalogDatabaseMapper catalogDatabaseMapper;
    private final CatalogTableMapper catalogTableMapper;
    private final CatalogFunctionMapper catalogFunctionMapper;

    @Override
    public List<CatalogDatabaseDTO> listDatabases(CatalogType type, String catalog) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogDatabase.class).eq(CatalogDatabase::getType, (Object)type)).eq(CatalogDatabase::getCatalog, (Object)catalog)).orderByAsc(CatalogDatabase::getName);
        List databases = this.catalogDatabaseMapper.selectList((Wrapper)queryWrapper);
        return CatalogDatabaseConvert.INSTANCE.toDto(databases);
    }

    @Override
    public Optional<CatalogDatabaseDTO> getDatabase(CatalogType type, String catalog, String database) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogDatabase.class).eq(CatalogDatabase::getCatalog, (Object)catalog)).eq(CatalogDatabase::getName, (Object)database);
        CatalogDatabase record = (CatalogDatabase)((Object)this.catalogDatabaseMapper.selectOne((Wrapper)queryWrapper));
        return Optional.ofNullable(record).map(CatalogDatabaseConvert.INSTANCE::toDto);
    }

    @Override
    public boolean databaseExists(CatalogType type, String catalog, String database) {
        Optional<CatalogDatabaseDTO> optional = this.getDatabase(type, catalog, database);
        return optional.isPresent();
    }

    @Override
    public void insertDatabase(CatalogDatabaseDTO database) throws DatabaseAlreadyExistException {
        if (this.databaseExists(database.getType(), database.getCatalog(), database.getName())) {
            throw new DatabaseAlreadyExistException(database.getCatalog(), database.getName());
        }
        CatalogDatabase record = CatalogDatabaseConvert.INSTANCE.toDo(database);
        this.catalogDatabaseMapper.insert((Object)record);
    }

    @Override
    public void updateDatabase(CatalogDatabaseDTO database) throws DatabaseNotExistException {
        if (!this.databaseExists(database.getType(), database.getCatalog(), database.getName())) {
            throw new DatabaseNotExistException(database.getCatalog(), database.getName());
        }
        CatalogDatabase record = CatalogDatabaseConvert.INSTANCE.toDo(database);
        this.catalogDatabaseMapper.updateById((Object)record);
    }

    @Override
    public void deleteDatabase(CatalogType type, String catalog, String database) throws DatabaseNotExistException {
        if (!this.databaseExists(type, catalog, database)) {
            throw new DatabaseNotExistException(catalog, database);
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogDatabase.class).eq(CatalogDatabase::getType, (Object)type)).eq(CatalogDatabase::getCatalog, (Object)catalog)).eq(CatalogDatabase::getName, (Object)database);
        CatalogDatabase record = new CatalogDatabase();
        record.setType(type);
        record.setCatalog(catalog);
        record.setName(database);
        this.catalogDatabaseMapper.update((Object)record, (Wrapper)queryWrapper);
    }

    @Override
    public boolean isDatabaseEmpty(CatalogType type, String catalog, String database) {
        int tableCount = this.catalogTableMapper.countByDatabase(type, catalog, database, CatalogTableKind.TABLE);
        int functionCount = this.catalogFunctionMapper.countByDatabase(type, catalog, database);
        return tableCount != 0 || functionCount != 0;
    }

    @Override
    public List<CatalogTableDTO> listTables(CatalogType type, String catalog, String database) {
        List<CatalogTable> records = this.catalogTableMapper.selectByDatabase(type, catalog, database, CatalogTableKind.TABLE);
        return CatalogTableConvert.INSTANCE.toDto(records);
    }

    @Override
    public Optional<CatalogTableDTO> getTable(CatalogType type, String catalog, String database, String table) {
        Optional<CatalogTable> optional = this.catalogTableMapper.selectByName(type, catalog, database, CatalogTableKind.TABLE, table);
        return optional.map(CatalogTableConvert.INSTANCE::toDto);
    }

    @Override
    public boolean tableExists(CatalogType type, String catalog, String database, String table) {
        Optional<CatalogTableDTO> optional = this.getTable(type, catalog, database, table);
        return optional.isPresent();
    }

    @Override
    public void insertTable(CatalogType type, String catalog, String database, CatalogTableDTO table) throws DatabaseNotExistException, TableAlreadyExistException {
        CatalogDatabaseDTO catalogDatabaseDTO = this.getDatabase(type, catalog, database).orElseThrow(() -> new DatabaseNotExistException(catalog, database));
        if (this.tableExists(type, catalog, database, table.getName())) {
            throw new TableAlreadyExistException(catalog, new ObjectPath(database, table.getName()));
        }
        CatalogTable record = CatalogTableConvert.INSTANCE.toDo(table);
        record.setDatabaseId(catalogDatabaseDTO.getId());
        this.catalogTableMapper.insert((Object)record);
    }

    @Override
    public void updateTable(CatalogType type, String catalog, String database, CatalogTableDTO table) throws TableNotExistException {
        if (!this.tableExists(type, catalog, database, table.getName())) {
            throw new TableNotExistException(catalog, new ObjectPath(database, table.getName()));
        }
        CatalogTable record = CatalogTableConvert.INSTANCE.toDo(table);
        this.catalogTableMapper.updateById((Object)record);
    }

    @Override
    public void renameTable(CatalogType type, String catalog, String database, String currentName, String newName) throws TableAlreadyExistException, TableNotExistException {
        CatalogTableDTO catalogTableDTO = this.getTable(type, catalog, database, currentName).orElseThrow(() -> new TableNotExistException(catalog, new ObjectPath(database, currentName)));
        if (this.tableExists(type, catalog, database, newName)) {
            throw new TableAlreadyExistException(catalog, new ObjectPath(database, newName));
        }
        CatalogTable record = CatalogTableConvert.INSTANCE.toDo(catalogTableDTO);
        record.setName(newName);
        this.catalogTableMapper.updateById((Object)record);
    }

    @Override
    public void deleteTable(CatalogType type, String catalog, String database, String table) throws TableNotExistException {
        if (!this.tableExists(type, catalog, database, table)) {
            throw new TableNotExistException(catalog, new ObjectPath(database, table));
        }
        this.catalogTableMapper.deleteByName(type, catalog, database, CatalogTableKind.TABLE, table);
    }

    @Override
    public List<CatalogTableDTO> listViews(CatalogType type, String catalog, String database) {
        List<CatalogTable> views = this.catalogTableMapper.selectByDatabase(type, catalog, database, CatalogTableKind.VIEW);
        return CatalogTableConvert.INSTANCE.toDto(views);
    }

    @Override
    public Optional<CatalogTableDTO> getView(CatalogType type, String catalog, String database, String view) {
        Optional<CatalogTable> optional = this.catalogTableMapper.selectByName(type, catalog, database, CatalogTableKind.VIEW, view);
        return optional.map(CatalogTableConvert.INSTANCE::toDto);
    }

    @Override
    public boolean viewExists(CatalogType type, String catalog, String database, String view) {
        Optional<CatalogTableDTO> optional = this.getView(type, catalog, database, view);
        return optional.isPresent();
    }

    @Override
    public void insertView(CatalogType type, String catalog, String database, CatalogTableDTO view) throws DatabaseNotExistException, TableAlreadyExistException {
        CatalogDatabaseDTO catalogDatabaseDTO = this.getDatabase(type, catalog, database).orElseThrow(() -> new DatabaseNotExistException(catalog, database));
        if (this.viewExists(type, catalog, database, view.getName())) {
            throw new TableAlreadyExistException(catalog, new ObjectPath(database, view.getName()));
        }
        CatalogTable record = CatalogTableConvert.INSTANCE.toDo(view);
        record.setDatabaseId(catalogDatabaseDTO.getId());
        this.catalogTableMapper.insert((Object)record);
    }

    @Override
    public void updateView(CatalogType type, String catalog, String database, CatalogTableDTO view) throws TableNotExistException {
        if (!this.viewExists(type, catalog, database, view.getName())) {
            throw new TableNotExistException(catalog, new ObjectPath(database, view.getName()));
        }
        CatalogTable record = CatalogTableConvert.INSTANCE.toDo(view);
        this.catalogTableMapper.updateById((Object)record);
    }

    @Override
    public void renameView(CatalogType type, String catalog, String database, String currentName, String newName) throws TableNotExistException, TableAlreadyExistException {
        CatalogTableDTO catalogViewDTO = this.getView(type, catalog, database, currentName).orElseThrow(() -> new TableNotExistException(catalog, new ObjectPath(database, currentName)));
        if (this.viewExists(type, catalog, database, newName)) {
            throw new TableAlreadyExistException(catalog, new ObjectPath(database, newName));
        }
        CatalogTable record = CatalogTableConvert.INSTANCE.toDo(catalogViewDTO);
        record.setName(newName);
        this.catalogTableMapper.updateById((Object)record);
    }

    @Override
    public void deleteView(CatalogType type, String catalog, String database, String viewName) throws TableNotExistException {
        if (!this.viewExists(type, catalog, database, viewName)) {
            throw new TableNotExistException(catalog, new ObjectPath(database, viewName));
        }
        this.catalogTableMapper.deleteByName(type, catalog, database, CatalogTableKind.VIEW, viewName);
    }

    @Override
    public List<CatalogFunctionDTO> listFunctions(CatalogType type, String catalog, String database) {
        List<CatalogFunction> catalogFunctions = this.catalogFunctionMapper.selectByDatabase(type, catalog, database);
        return CatalogFunctionConvert.INSTANCE.toDto(catalogFunctions);
    }

    @Override
    public Optional<CatalogFunctionDTO> getFunction(CatalogType type, String catalog, String database, String function) {
        Optional<CatalogFunction> optional = this.catalogFunctionMapper.selectByName(type, catalog, database, function);
        return optional.map(CatalogFunctionConvert.INSTANCE::toDto);
    }

    @Override
    public boolean functionExists(CatalogType type, String catalog, String database, String function) {
        Optional<CatalogFunctionDTO> optional = this.getFunction(type, catalog, database, function);
        return optional.isPresent();
    }

    @Override
    public void insertFunction(CatalogType type, String catalog, String database, CatalogFunctionDTO function) throws DatabaseNotExistException, FunctionAlreadyExistException {
        CatalogDatabaseDTO catalogDatabaseDTO = this.getDatabase(type, catalog, database).orElseThrow(() -> new DatabaseNotExistException(catalog, database));
        if (this.functionExists(type, catalog, database, function.getName())) {
            throw new FunctionAlreadyExistException(catalog, new ObjectPath(database, function.getName()));
        }
        CatalogFunction record = CatalogFunctionConvert.INSTANCE.toDo(function);
        record.setDatabaseId(catalogDatabaseDTO.getId());
        this.catalogFunctionMapper.insert((Object)record);
    }

    @Override
    public void updateFunction(CatalogType type, String catalog, String database, CatalogFunctionDTO function) throws FunctionNotExistException {
        if (!this.functionExists(type, catalog, database, function.getName())) {
            throw new FunctionNotExistException(catalog, new ObjectPath(database, function.getName()));
        }
        CatalogFunction record = CatalogFunctionConvert.INSTANCE.toDo(function);
        this.catalogFunctionMapper.updateById((Object)record);
    }

    @Override
    public void deleteFunction(CatalogType type, String catalog, String database, String functionName) throws FunctionNotExistException {
        if (!this.functionExists(type, catalog, database, functionName)) {
            throw new FunctionNotExistException(catalog, new ObjectPath(database, functionName));
        }
        this.catalogFunctionMapper.deleteByName(type, catalog, database, functionName);
    }

    @Generated
    public FlinkfulCatalogServiceImpl(CatalogDatabaseMapper catalogDatabaseMapper, CatalogTableMapper catalogTableMapper, CatalogFunctionMapper catalogFunctionMapper) {
        this.catalogDatabaseMapper = catalogDatabaseMapper;
        this.catalogTableMapper = catalogTableMapper;
        this.catalogFunctionMapper = catalogFunctionMapper;
    }
}

