/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.sakura.factory;

import cn.sliew.flinkful.sql.catalog.dict.flink.CatalogTableKind;
import cn.sliew.flinkful.sql.catalog.sakura.SakuraCatalogTable;
import cn.sliew.flinkful.sql.catalog.sakura.factory.CatalogSchemaFactory;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogTableDTO;
import org.apache.commons.lang3.EnumUtils;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;

public final class CatalogTableFactory
extends Enum<CatalogTableFactory> {
    private static final /* synthetic */ CatalogTableFactory[] $VALUES;

    public static CatalogTableFactory[] values() {
        return (CatalogTableFactory[])$VALUES.clone();
    }

    public static CatalogTableFactory valueOf(String name) {
        return Enum.valueOf(CatalogTableFactory.class, name);
    }

    public static CatalogTableDTO fromResolvedTable(String tableName, CatalogBaseTable catalogBaseTable) {
        CatalogTableDTO catalogTable = new CatalogTableDTO();
        catalogTable.setKind(CatalogTableKind.TABLE);
        catalogTable.setName(tableName);
        catalogTable.setProperties(catalogBaseTable.getOptions());
        catalogTable.setRemark(catalogBaseTable.getComment());
        if (catalogBaseTable instanceof ResolvedCatalogTable) {
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)catalogBaseTable;
            catalogTable.setSchema(CatalogSchemaFactory.toSchema(resolvedTable.getResolvedSchema()));
        }
        return catalogTable;
    }

    public static CatalogTableDTO fromUnresolvedTable(String tableName, CatalogBaseTable catalogBaseTable) {
        CatalogTableDTO catalogTable = new CatalogTableDTO();
        catalogTable.setKind(CatalogTableKind.TABLE);
        catalogTable.setName(tableName);
        catalogTable.setProperties(catalogBaseTable.getOptions());
        catalogTable.setRemark(catalogBaseTable.getComment());
        catalogTable.setSchema(CatalogSchemaFactory.toSchema(catalogBaseTable.getUnresolvedSchema()));
        return catalogTable;
    }

    public static SakuraCatalogTable toTable(CatalogTableDTO catalogTableDTO) {
        CatalogBaseTable.TableKind kind = (CatalogBaseTable.TableKind)EnumUtils.getEnum(CatalogBaseTable.TableKind.class, (String)catalogTableDTO.getKind().getValue());
        Schema schema = CatalogSchemaFactory.toCatalog(catalogTableDTO.getSchema());
        return new SakuraCatalogTable(kind, schema, catalogTableDTO.getProperties(), catalogTableDTO.getRemark());
    }

    private static /* synthetic */ CatalogTableFactory[] $values() {
        return new CatalogTableFactory[0];
    }

    static {
        $VALUES = CatalogTableFactory.$values();
    }
}

