/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.service.convert;

import cn.sliew.carp.framework.common.codec.CodecUtil;
import cn.sliew.carp.framework.common.convert.BaseConvert;
import cn.sliew.flinkful.sql.catalog.repository.entity.CatalogStore;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogStoreDTO;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;
import org.springframework.beans.BeanUtils;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE)
public interface CatalogStoreConvert
extends BaseConvert<CatalogStore, CatalogStoreDTO> {
    public static final CatalogStoreConvert INSTANCE = (CatalogStoreConvert)Mappers.getMapper(CatalogStoreConvert.class);

    default public CatalogStore toDo(CatalogStoreDTO dto) {
        try {
            CatalogStore entity = new CatalogStore();
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
            entity.setName(dto.getCatalogName());
            if (dto.getConfiguration() != null) {
                entity.setConfiguration(CodecUtil.decrypt((String)JacksonUtil.toJsonString((Object)dto.getConfiguration())));
            }
            return entity;
        }
        catch (Exception e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }

    default public CatalogStoreDTO toDto(CatalogStore entity) {
        try {
            CatalogStoreDTO dto = new CatalogStoreDTO();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
            dto.setCatalogName(entity.getName());
            if (entity != null && StringUtils.isNotBlank((CharSequence)entity.getConfiguration())) {
                Map configuration = (Map)JacksonUtil.parseJsonString((String)CodecUtil.decrypt((String)entity.getConfiguration()), (TypeReference)new TypeReference<Map<String, String>>(){});
                dto.setConfiguration(Configuration.fromMap((Map)configuration));
            }
            return dto;
        }
        catch (Exception e) {
            Rethrower.throwAs((Throwable)e);
            return null;
        }
    }
}

