/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.sakura.factory;

import cn.sliew.flinkful.sql.catalog.dict.flink.CatalogTableKind;
import cn.sliew.flinkful.sql.catalog.sakura.SakuraCatalogView;
import cn.sliew.flinkful.sql.catalog.sakura.factory.CatalogSchemaFactory;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogTableDTO;
import org.apache.commons.lang3.EnumUtils;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;

public final class CatalogViewFactory
extends Enum<CatalogViewFactory> {
    private static final /* synthetic */ CatalogViewFactory[] $VALUES;

    public static CatalogViewFactory[] values() {
        return (CatalogViewFactory[])$VALUES.clone();
    }

    public static CatalogViewFactory valueOf(String name) {
        return Enum.valueOf(CatalogViewFactory.class, name);
    }

    public static CatalogTableDTO fromResolvedView(String viewName, ResolvedCatalogView resolvedView) {
        CatalogTableDTO catalogView = new CatalogTableDTO();
        catalogView.setKind(CatalogTableKind.VIEW);
        catalogView.setName(viewName);
        catalogView.setSchema(CatalogSchemaFactory.toSchema(resolvedView.getResolvedSchema()));
        catalogView.setProperties(resolvedView.getOptions());
        catalogView.setOriginalQuery(resolvedView.getOriginalQuery());
        catalogView.setExpandedQuery(resolvedView.getExpandedQuery());
        catalogView.setRemark(resolvedView.getComment());
        return catalogView;
    }

    public static CatalogTableDTO fromUnresolvedTable(String viewName, CatalogBaseTable catalogBaseTable) {
        CatalogTableDTO catalogView = new CatalogTableDTO();
        catalogView.setKind(CatalogTableKind.VIEW);
        catalogView.setName(viewName);
        catalogView.setSchema(CatalogSchemaFactory.toSchema(catalogBaseTable.getUnresolvedSchema()));
        catalogView.setProperties(catalogBaseTable.getOptions());
        catalogView.setOriginalQuery(catalogView.getOriginalQuery());
        catalogView.setExpandedQuery(catalogView.getExpandedQuery());
        catalogView.setRemark(catalogBaseTable.getComment());
        return catalogView;
    }

    public static SakuraCatalogView toView(CatalogTableDTO catalogTableDTO) {
        CatalogBaseTable.TableKind kind = (CatalogBaseTable.TableKind)EnumUtils.getEnum(CatalogBaseTable.TableKind.class, (String)catalogTableDTO.getKind().getValue());
        Schema schema = CatalogSchemaFactory.toCatalog(catalogTableDTO.getSchema());
        return new SakuraCatalogView(kind, schema, catalogTableDTO.getProperties(), catalogTableDTO.getRemark(), catalogTableDTO.getOriginalQuery(), catalogTableDTO.getExpandedQuery());
    }

    private static /* synthetic */ CatalogViewFactory[] $values() {
        return new CatalogViewFactory[0];
    }

    static {
        $VALUES = CatalogViewFactory.$values();
    }
}

