/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.flinkful.sql.catalog.service.impl;

import cn.sliew.flinkful.sql.catalog.dict.CatalogType;
import cn.sliew.flinkful.sql.catalog.repository.entity.CatalogStore;
import cn.sliew.flinkful.sql.catalog.repository.mapper.CatalogStoreMapper;
import cn.sliew.flinkful.sql.catalog.service.FlinkfulCatalogStoreService;
import cn.sliew.flinkful.sql.catalog.service.convert.CatalogStoreConvert;
import cn.sliew.flinkful.sql.catalog.service.dto.CatalogStoreDTO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class FlinkfulCatalogStoreServiceImpl
extends ServiceImpl<CatalogStoreMapper, CatalogStore>
implements FlinkfulCatalogStoreService {
    @Override
    public List<CatalogStoreDTO> list(CatalogType type) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogStore.class).eq(CatalogStore::getType, (Object)type)).orderByAsc(CatalogStore::getName);
        List catalogs = this.list((Wrapper)queryWrapper);
        return CatalogStoreConvert.INSTANCE.toDto(catalogs);
    }

    @Override
    public Optional<CatalogStoreDTO> get(CatalogType type, String catalogName) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CatalogStore.class).eq(CatalogStore::getType, (Object)type)).eq(CatalogStore::getName, (Object)catalogName);
        Optional catalog = this.getOneOpt((Wrapper)queryWrapper);
        return catalog.map(CatalogStoreConvert.INSTANCE::toDto);
    }

    @Override
    public void add(CatalogStoreDTO dto) {
        CatalogStore record = CatalogStoreConvert.INSTANCE.toDo(dto);
        this.save((Object)record);
    }

    @Override
    public void update(CatalogStoreDTO dto) {
        CatalogStore record = CatalogStoreConvert.INSTANCE.toDo(dto);
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CatalogStore.class).eq(CatalogStore::getType, (Object)record.getType())).eq(CatalogStore::getName, (Object)record.getName());
        this.update((Object)record, (Wrapper)updateWrapper);
    }

    @Override
    public void delete(CatalogType type, String catalogName) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(CatalogStore.class).eq(CatalogStore::getType, (Object)type)).eq(CatalogStore::getName, (Object)catalogName);
        this.remove((Wrapper)updateWrapper);
    }
}

