/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FlatSettingsHelper {
    private FlatSettingsHelper() {
        throw new IllegalStateException("no instance");
    }

    public static Map<String, Object> flatSettingsMap(Map<String, Object> settings) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        settings.forEach((key, value) -> FlatSettingsHelper.processSetting(map, "", key, value));
        map.entrySet().stream().filter(entry -> entry.getValue() instanceof Map).forEach(entry -> entry.setValue(FlatSettingsHelper.convertMapsToArrays((Map)entry.getValue())));
        return map;
    }

    public static void processSetting(Map<String, Object> map, String prefix, String setting, Object value) {
        int prefixLength = setting.indexOf(46);
        if (prefixLength == -1) {
            Map innerMap = (Map)map.get(prefix + setting);
            if (innerMap != null) {
                innerMap.forEach((innerKey, innerValue) -> map.put(prefix + setting + "." + innerKey, innerValue));
            }
            map.put(prefix + setting, value);
        } else {
            String key = setting.substring(0, prefixLength);
            String rest = setting.substring(prefixLength + 1);
            Object existingValue = map.get(prefix + key);
            if (existingValue == null) {
                HashMap<String, Object> newMap = new HashMap<String, Object>(2);
                FlatSettingsHelper.processSetting(newMap, "", rest, value);
                map.put(prefix + key, newMap);
            } else if (existingValue instanceof Map) {
                Map innerMap = (Map)existingValue;
                FlatSettingsHelper.processSetting(innerMap, "", rest, value);
                map.put(prefix + key, innerMap);
            } else {
                FlatSettingsHelper.processSetting(map, prefix + key + ".", rest, value);
            }
        }
    }

    public static Object convertMapsToArrays(Map<String, Object> map) {
        if (map.isEmpty()) {
            return map;
        }
        boolean isArray = true;
        int maxIndex = -1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isArray) {
                try {
                    int index = Integer.parseInt(entry.getKey());
                    if (index >= 0) {
                        maxIndex = Math.max(maxIndex, index);
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException ex) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(FlatSettingsHelper.convertMapsToArrays(valMap));
        }
        if (isArray && maxIndex + 1 == map.size()) {
            ArrayList<Object> newValue = new ArrayList<Object>(maxIndex + 1);
            for (int i = 0; i <= maxIndex; ++i) {
                Object obj = map.get(Integer.toString(i));
                if (obj == null) {
                    return map;
                }
                newValue.add(obj);
            }
            return newValue;
        }
        return map;
    }
}

