/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.settings;

import cn.sliew.milky.common.collect.SetOnce;
import cn.sliew.milky.common.primitives.Booleans;
import cn.sliew.milky.common.primitives.Doubles;
import cn.sliew.milky.common.primitives.Floats;
import cn.sliew.milky.common.primitives.Integers;
import cn.sliew.milky.common.primitives.Longs;
import cn.sliew.milky.common.primitives.Strings;
import cn.sliew.milky.common.settings.FilteredMap;
import cn.sliew.milky.common.settings.SettingsBuilder;
import cn.sliew.milky.common.settings.SettingsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Settings {
    final Map<String, Object> settings;
    private final Set<String> keys;
    private final SetOnce<Set<String>> firstLevelNames = new SetOnce();

    Settings(Map<String, Object> settings) {
        this.settings = settings;
        this.keys = Collections.unmodifiableSet(settings.keySet());
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public int size() {
        return this.keySet().size();
    }

    public Set<String> keySet() {
        return this.keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> names() {
        if (this.firstLevelNames.get() == null) {
            SetOnce<Set<String>> setOnce = this.firstLevelNames;
            synchronized (setOnce) {
                if (this.firstLevelNames.get() == null) {
                    Stream stream = this.settings.keySet().stream();
                    Set names = stream.map(k -> {
                        int i = k.indexOf(46);
                        if (i < 0) {
                            return k;
                        }
                        return k.substring(0, i);
                    }).collect(Collectors.toSet());
                    this.firstLevelNames.set(Collections.unmodifiableSet(names));
                }
            }
        }
        return this.firstLevelNames.get();
    }

    public boolean hasValue(String key) {
        return this.settings.get(key) != null;
    }

    public String get(String setting) {
        return Settings.toString(this.settings.get(setting));
    }

    public String get(String setting, String defaultValue) {
        return Optional.ofNullable(this.get(setting)).orElse(defaultValue);
    }

    public Settings getByPrefix(String prefix) {
        return new Settings(new FilteredMap(this.settings, k -> k.startsWith(prefix), prefix));
    }

    public Settings getAsSettings(String setting) {
        return this.getByPrefix(setting + ".");
    }

    public Settings filter(Predicate<String> predicate) {
        return new Settings(new FilteredMap(this.settings, predicate, null));
    }

    public Float getAsFloat(String setting, Float defaultValue) {
        return Floats.parseFloat(this.get(setting), defaultValue);
    }

    public Double getAsDouble(String setting, Double defaultValue) {
        return Doubles.parseDouble(this.get(setting), defaultValue);
    }

    public Integer getAsInt(String setting, Integer defaultValue) {
        return Integers.parseInteger(this.get(setting), defaultValue);
    }

    public Long getAsLong(String setting, Long defaultValue) {
        return Longs.parseLong(this.get(setting), defaultValue);
    }

    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return Booleans.parseBoolean(this.get(setting), defaultValue);
    }

    public List<String> getAsList(String key) throws SettingsException {
        return this.getAsList(key, Collections.emptyList());
    }

    public List<String> getAsList(String key, List<String> defaultValue) throws SettingsException {
        return this.getAsList(key, defaultValue, true);
    }

    public List<String> getAsList(String key, List<String> defaultValue, Boolean commaDelimited) throws SettingsException {
        ArrayList<String> result = new ArrayList<String>();
        Object valueFromPrefix = this.settings.get(key);
        if (valueFromPrefix != null) {
            if (valueFromPrefix instanceof List) {
                return Collections.unmodifiableList((List)valueFromPrefix);
            }
            if (commaDelimited.booleanValue()) {
                String[] strings = Strings.splitStringByCommaToArray(this.get(key));
                if (strings.length > 0) {
                    for (String string : strings) {
                        result.add(string.trim());
                    }
                }
            } else {
                result.add(this.get(key).trim());
            }
        }
        if (result.isEmpty()) {
            return defaultValue;
        }
        return Collections.unmodifiableList(result);
    }

    public Map<String, Settings> getAsGroups() throws SettingsException {
        return this.getGroups("");
    }

    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        return this.getGroups(settingPrefix, false);
    }

    public Map<String, Settings> getGroups(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        if (!Strings.hasLength(settingPrefix)) {
            throw new IllegalArgumentException("illegal setting prefix " + settingPrefix);
        }
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        return this.getGroupsInternal(settingPrefix, ignoreNonGrouped);
    }

    private Map<String, Settings> getGroupsInternal(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        Settings prefixSettings = this.getByPrefix(settingPrefix);
        HashMap<String, Settings> groups = new HashMap<String, Settings>();
        for (String groupName : prefixSettings.names()) {
            Settings groupSettings = prefixSettings.getByPrefix(groupName + ".");
            if (groupSettings.isEmpty()) {
                if (ignoreNonGrouped) continue;
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + settingPrefix + groupName + "] because of a missing '.'");
            }
            groups.put(groupName, groupSettings);
        }
        return Collections.unmodifiableMap(groups);
    }

    static String toString(Object o) {
        return Objects.toString(o, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings that = (Settings)o;
        return Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return this.settings != null ? this.settings.hashCode() : 0;
    }

    public static SettingsBuilder builder() {
        return new SettingsBuilder();
    }
}

