/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.util;

import cn.sliew.milky.common.exception.Rethrower;
import java.util.Arrays;

public final class StringUtils {
    private StringUtils() {
        throw new IllegalStateException("can't do this!");
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String camelToSplitName(String camelName, String split) {
        if (StringUtils.isBlank(camelName)) {
            return camelName;
        }
        StringBuilder buf = null;
        for (int i = 0; i < camelName.length(); ++i) {
            char ch = camelName.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                if (buf == null) {
                    buf = new StringBuilder();
                    if (i > 0) {
                        buf.append(camelName, 0, i);
                    }
                }
                if (i > 0) {
                    buf.append(split);
                }
                buf.append(Character.toLowerCase(ch));
                continue;
            }
            if (buf == null) continue;
            buf.append(ch);
        }
        return buf == null ? camelName : buf.toString();
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        try {
            if (obj.getClass().isArray()) {
                if (obj.getClass().getComponentType().isPrimitive()) {
                    if (obj instanceof boolean[]) {
                        return Arrays.toString((boolean[])obj);
                    }
                    if (obj instanceof char[]) {
                        return Arrays.toString((char[])obj);
                    }
                    if (obj instanceof short[]) {
                        return Arrays.toString((short[])obj);
                    }
                    if (obj instanceof byte[]) {
                        return Arrays.toString((byte[])obj);
                    }
                    if (obj instanceof int[]) {
                        return Arrays.toString((int[])obj);
                    }
                    if (obj instanceof long[]) {
                        return Arrays.toString((long[])obj);
                    }
                    if (obj instanceof float[]) {
                        return Arrays.toString((float[])obj);
                    }
                    if (obj instanceof double[]) {
                        return Arrays.toString((double[])obj);
                    }
                }
                return Arrays.deepToString((Object[])obj);
            }
            String result = obj.toString();
            return result != null ? result : "null";
        }
        catch (Throwable throwable) {
            Rethrower.rethrowIfUnrecoverable(throwable);
            return StringUtils.defaultToString(obj);
        }
    }

    public static String defaultToString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }
}

