/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.environment;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.environment.MapPropertySource;
import cn.sliew.milky.common.environment.PropertySource;
import cn.sliew.milky.common.environment.PropertySourceIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

public class MutablePropertySources
implements PropertySourceIterable {
    private final List<PropertySource<?>> propertySourceList = new CopyOnWriteArrayList();

    public MutablePropertySources() {
    }

    public MutablePropertySources(PropertySourceIterable propertySources) {
        this();
        propertySources.forEach(this::addLast);
    }

    @Override
    public Iterator<PropertySource<?>> iterator() {
        return this.propertySourceList.iterator();
    }

    @Override
    public Spliterator<PropertySource<?>> spliterator() {
        return Spliterators.spliterator(this.propertySourceList, 0);
    }

    @Override
    public Stream<PropertySource<?>> stream() {
        return this.propertySourceList.stream();
    }

    @Override
    public boolean containsPropertySource(String name) {
        return this.propertySourceList.stream().filter(propertySource -> propertySource.getName().equals(name)).findAny().isPresent();
    }

    @Override
    public Optional<PropertySource<?>> getPropertySource(String name) {
        return this.propertySourceList.stream().filter(propertySource -> propertySource.getName().equals(name)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(PropertySource<?> propertySource) {
        Ensures.checkNotNull(propertySource);
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(0, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(PropertySource<?> propertySource) {
        Ensures.checkNotNull(propertySource);
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            this.propertySourceList.add(propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBefore(String relativePropertySourceName, PropertySource<?> propertySource) {
        Ensures.notBlank(relativePropertySourceName);
        Ensures.checkNotNull(propertySource);
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            int index = this.assertPresentAndGetIndex(relativePropertySourceName);
            this.addAtIndex(index, propertySource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfter(String relativePropertySourceName, PropertySource<?> propertySource) {
        Ensures.notBlank(relativePropertySourceName);
        Ensures.checkNotNull(propertySource);
        this.assertLegalRelativeAddition(relativePropertySourceName, propertySource);
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            this.removeIfPresent(propertySource);
            int index = this.assertPresentAndGetIndex(relativePropertySourceName);
            this.addAtIndex(index + 1, propertySource);
        }
    }

    public int precedenceOf(PropertySource<?> propertySource) {
        Ensures.checkNotNull(propertySource);
        return this.propertySourceList.indexOf(propertySource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<PropertySource<?>> remove(String name) {
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            int index = this.propertySourceList.indexOf(new MapPropertySource(name, Collections.emptyMap()));
            return index != -1 ? Optional.of(this.propertySourceList.remove(index)) : Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String name, PropertySource<?> propertySource) {
        List<PropertySource<?>> list = this.propertySourceList;
        synchronized (list) {
            int index = this.assertPresentAndGetIndex(name);
            this.propertySourceList.set(index, propertySource);
        }
    }

    public int size() {
        return this.propertySourceList.size();
    }

    public String toString() {
        return this.propertySourceList.toString();
    }

    protected void removeIfPresent(PropertySource<?> propertySource) {
        this.propertySourceList.remove(propertySource);
    }

    protected void assertLegalRelativeAddition(String relativePropertySourceName, PropertySource<?> propertySource) {
        String newPropertySourceName = propertySource.getName();
        if (relativePropertySourceName.equals(newPropertySourceName)) {
            throw new IllegalArgumentException("PropertySource named '" + newPropertySourceName + "' cannot be added relative to itself");
        }
    }

    private void addAtIndex(int index, PropertySource<?> propertySource) {
        this.removeIfPresent(propertySource);
        this.propertySourceList.add(index, propertySource);
    }

    private int assertPresentAndGetIndex(String name) {
        int index = this.propertySourceList.indexOf(new MapPropertySource(name, Collections.emptyMap()));
        if (index == -1) {
            throw new IllegalArgumentException("PropertySource named '" + name + "' does not exist");
        }
        return index;
    }
}

