/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.primitives;

import cn.sliew.milky.common.check.Ensures;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class Enums {
    private static final Map<Class<?>, Map<String, ?>> NORMALIZED_ENUMS = new ConcurrentHashMap();

    private Enums() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static <T1 extends Enum<T1>, T2 extends Enum<T2>> T2 convertTo(T1 ie, Class<T2> oe) {
        if (ie == null) {
            return null;
        }
        return Enum.valueOf(oe, ie.name());
    }

    public static <T extends Enum<T>> Optional<T> toEnum(String value, Class<T> enumClass) {
        Ensures.checkArgument(enumClass.isEnum());
        if (!NORMALIZED_ENUMS.containsKey(enumClass)) {
            Enum[] values = (Enum[])enumClass.getEnumConstants();
            HashMap<String, Enum> mappings = new HashMap<String, Enum>(values.length);
            for (Enum t : values) {
                mappings.put(Enums.normalizeName(t.name()), t);
            }
            NORMALIZED_ENUMS.put(enumClass, mappings);
        }
        return Optional.ofNullable((Enum)NORMALIZED_ENUMS.get(enumClass).get(Enums.normalizeName(value)));
    }

    private static String normalizeName(String name) {
        return name.toLowerCase().replaceAll("[^a-zA-Z0-9]", "");
    }
}

