/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.recycler;

import cn.sliew.milky.common.recycler.AbstractRecycler;
import cn.sliew.milky.common.recycler.Source;
import cn.sliew.milky.common.recycler.Value;
import java.util.Deque;

public class DequeRecycler<T>
extends AbstractRecycler<T> {
    final Deque<T> deque;
    final int maxSize;

    public DequeRecycler(Source<T> source, Deque<T> deque, int maxSize) {
        super(source);
        this.deque = deque;
        this.maxSize = maxSize;
    }

    @Override
    public Value<T> obtain() {
        T v = this.deque.pollFirst();
        if (v == null) {
            return new DefaultValue(this.source.newInstance(), false);
        }
        return new DefaultValue(v, true);
    }

    protected boolean beforeRelease() {
        return this.deque.size() < this.maxSize;
    }

    protected void afterRelease(boolean recycled) {
    }

    private class DefaultValue
    implements Value<T> {
        T value;
        final boolean recycled;

        DefaultValue(T value, boolean recycled) {
            this.value = value;
            this.recycled = recycled;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public boolean isRecycled() {
            return this.recycled;
        }

        @Override
        public void close() {
            if (this.value == null) {
                throw new IllegalStateException("recycler entry already released...");
            }
            boolean recycle = DequeRecycler.this.beforeRelease();
            if (recycle) {
                DequeRecycler.this.source.recycle(this.value);
                DequeRecycler.this.deque.addFirst(this.value);
            } else {
                DequeRecycler.this.source.destroy(this.value);
            }
            this.value = null;
            DequeRecycler.this.afterRelease(recycle);
        }
    }
}

