/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.util;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class ToStringBuilder {
    private final String typeName;
    private final List<String> values = new ArrayList<String>();

    public ToStringBuilder(Object obj) {
        this(Ensures.checkNotNull(obj, () -> "Object must not be null").getClass().getSimpleName());
    }

    public ToStringBuilder(Class<?> type) {
        this(Ensures.checkNotNull(type, () -> "Class must not be null").getSimpleName());
    }

    public ToStringBuilder(String typeName) {
        this.typeName = Ensures.checkNotNull(typeName, () -> "Type name must not be null");
    }

    public ToStringBuilder append(String name, Object value) {
        Ensures.notBlank(name, () -> "Name must not be null or blank");
        this.values.add(name + " = " + this.toString(value));
        return this;
    }

    private String toString(Object obj) {
        return obj instanceof CharSequence ? "'" + obj + "'" : StringUtils.nullSafeToString(obj);
    }

    public String toString() {
        return this.typeName + " [" + String.join((CharSequence)", ", this.values) + "]";
    }
}

