/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.diff;

import cn.sliew.milky.common.diff.Diff;
import cn.sliew.milky.common.diff.Diffable;
import cn.sliew.milky.common.diff.MapDiff;
import java.util.HashMap;
import java.util.Map;

public class JdkMapDiff<K, T>
extends MapDiff<K, T, Map<K, T>> {
    public static <K, T> MapDiff<K, T, Map<K, T>> diff(Map<K, T> before, Map<K, T> after) {
        assert (after != null && before != null);
        return new JdkMapDiff<K, T>(before, after);
    }

    public JdkMapDiff(Map<K, T> before, Map<K, T> after) {
        assert (after != null && before != null);
        for (K k : before.keySet()) {
            if (after.containsKey(k)) continue;
            this.deletes.add(k);
        }
        for (Map.Entry entry : after.entrySet()) {
            T beforePart = before.get(entry.getKey());
            Object afterPart = entry.getValue();
            if (beforePart == null) {
                this.upserts.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (afterPart.equals(beforePart)) continue;
            if (beforePart instanceof Diffable && afterPart instanceof Diffable) {
                Diffable beforeDiffable = (Diffable)beforePart;
                Diffable afterDiffable = (Diffable)afterPart;
                this.diffs.put(entry.getKey(), afterDiffable.diff(beforeDiffable));
                continue;
            }
            this.upserts.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<K, T> apply(Map<K, T> map) {
        HashMap builder = new HashMap(map);
        for (Object e : this.deletes) {
            builder.remove(e);
        }
        for (Map.Entry entry : this.diffs.entrySet()) {
            builder.put(entry.getKey(), ((Diff)entry.getValue()).apply(builder.get(entry.getKey())));
        }
        for (Map.Entry entry : this.upserts.entrySet()) {
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder;
    }
}

