/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.util;

import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.common.util.StringUtils;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JavaPropsMapper PROPS_MAPPER = new JavaPropsMapper();

    private JacksonUtil() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static String toJsonString(Object object) {
        return JacksonUtil.toJsonString(OBJECT_MAPPER, object);
    }

    public static String toJsonString(ObjectMapper mapper, Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("json \u5e8f\u5217\u5316\u5931\u8d25 object: {}", object, (Object)e);
            Rethrower.throwAs(e);
            return null;
        }
    }

    public static <T> T parseJsonString(String json, Class<T> clazz) {
        return JacksonUtil.parseJsonString(OBJECT_MAPPER, json, clazz);
    }

    public static <T> T parseJsonString(ObjectMapper mapper, String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            log.error("json \u53cd\u5e8f\u5217\u5316\u5931\u8d25 clazz: {}, json: {}", new Object[]{clazz.getName(), json, e});
            Rethrower.throwAs(e);
            return null;
        }
    }

    public static <T> T parseJsonString(String json, TypeReference<T> reference) {
        return JacksonUtil.parseJsonString(OBJECT_MAPPER, json, reference);
    }

    public static <T> T parseJsonString(ObjectMapper mapper, String json, TypeReference<T> reference) {
        try {
            return (T)mapper.readValue(json, reference);
        }
        catch (JsonProcessingException e) {
            log.error("json \u53cd\u5e8f\u5217\u5316\u5931\u8d25 clazz: {}, json: {}", new Object[]{reference.getType().getTypeName(), json, e});
            Rethrower.throwAs(e);
            return null;
        }
    }

    public static <T> T parseJsonString(String json, JavaType type) {
        return JacksonUtil.parseJsonString(OBJECT_MAPPER, json, type);
    }

    public static <T> T parseJsonString(ObjectMapper mapper, String json, JavaType type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            log.error("json \u53cd\u5e8f\u5217\u5316\u5931\u8d25 clazz: {}, json: {}", new Object[]{type.getTypeName(), json, e});
            Rethrower.throwAs(e);
            return null;
        }
    }

    public static <T> T parseJsonString(String json, Class<T> outerType, Class parameterClasses) {
        return JacksonUtil.parseJsonString(OBJECT_MAPPER, json, outerType, parameterClasses);
    }

    public static <T> T parseJsonString(ObjectMapper mapper, String json, Class<T> outerType, Class parameterClasses) {
        JavaType type = mapper.getTypeFactory().constructParametricType(outerType, new Class[]{parameterClasses});
        return JacksonUtil.parseJsonString(mapper, json, type);
    }

    public static <T> List<T> parseJsonArray(String json, Class<T> clazz) {
        return JacksonUtil.parseJsonArray(OBJECT_MAPPER, json, clazz);
    }

    public static <T> List<T> parseJsonArray(ObjectMapper mapper, String json, Class<T> clazz) {
        if (StringUtils.isBlank(json)) {
            return Collections.emptyList();
        }
        try {
            CollectionType listType = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)mapper.readValue(json, (JavaType)listType);
        }
        catch (Exception e) {
            log.error("json \u53cd\u5e8f\u5217\u5316\u4e3a list \u5931\u8d25 clazz: {}, json: {}", clazz.getName(), json, e);
            return Collections.emptyList();
        }
    }

    public static ArrayNode createArrayNode() {
        return OBJECT_MAPPER.createArrayNode();
    }

    public static ObjectNode createObjectNode() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static JsonNode toJsonNode(Object obj) {
        return OBJECT_MAPPER.valueToTree(obj);
    }

    public static JsonNode toJsonNode(String json) {
        try {
            return OBJECT_MAPPER.readTree(json);
        }
        catch (JsonProcessingException e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    public static <T> T toObject(JsonNode jsonNode, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue((Object)jsonNode, clazz);
    }

    public static <T> T toObject(JsonNode jsonNode, TypeReference<T> typeReference) {
        return (T)OBJECT_MAPPER.convertValue((Object)jsonNode, typeReference);
    }

    public static <T> T toObject(Object object, Class<T> clazz) {
        return (T)OBJECT_MAPPER.convertValue(object, clazz);
    }

    public static Map<String, Object> toMap(JsonNode jsonNode) {
        return JacksonUtil.toObject(jsonNode, new TypeReference<Map<String, Object>>(){});
    }

    public static Properties toProps(String json) {
        try {
            return PROPS_MAPPER.writeValueAsProperties((Object)json);
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    public static boolean checkJsonValid(String json) {
        if (StringUtils.isBlank(json)) {
            return false;
        }
        try {
            OBJECT_MAPPER.readTree(json);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static <T> T merge(T target, T patch, Class<T> resourceClass) {
        JsonNode targetNode = JacksonUtil.toJsonNode(target);
        JsonNode patchNode = JacksonUtil.toJsonNode(patch);
        JsonNode patched = JacksonUtil.merge(targetNode, patchNode);
        return JacksonUtil.toObject(patched, resourceClass);
    }

    public static JsonNode merge(JsonNode target, JsonNode patch) {
        if (!(patch instanceof ObjectNode)) {
            return patch;
        }
        ObjectNode patchObject = (ObjectNode)patch;
        ObjectNode targetObject = target instanceof ObjectNode ? (ObjectNode)target : patchObject.objectNode();
        patch.fields().forEachRemaining(field -> {
            String key = (String)field.getKey();
            JsonNode value = (JsonNode)field.getValue();
            if (value.isNull()) {
                targetObject.remove(key);
            } else {
                JsonNode existingValue = targetObject.get(key);
                JsonNode mergeResult = JacksonUtil.merge(existingValue, value);
                targetObject.replace(key, mergeResult);
            }
        });
        return targetObject;
    }

    public static ObjectMapper getMapper() {
        return OBJECT_MAPPER;
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

