/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache;

import cn.sliew.milky.cache.CacheLoader;
import cn.sliew.milky.cache.CacheWriter;
import cn.sliew.milky.common.check.Ensures;
import java.util.Objects;

public class CacheOptions<K, V> {
    private String name = "default-cache";
    private CacheLoader<K, V> loader;
    private CacheWriter<K, V> writer;
    private WriteMode writeMode = WriteMode.WRITE_THROUGH;
    private int writeBehindThreads = 1;

    protected CacheOptions() {
    }

    public static <K, V> CacheOptions<K, V> defaults() {
        return new CacheOptions<K, V>();
    }

    public CacheOptions<K, V> name(String name) {
        Ensures.notBlank(name, () -> "cache name can't be empty");
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CacheOptions<K, V> writer(CacheWriter<K, V> writer) {
        this.writer = writer;
        return this;
    }

    public CacheWriter<K, V> getWriter() {
        return this.writer;
    }

    public CacheOptions<K, V> writeBehindThreads(int writeBehindThreads) {
        this.writeBehindThreads = writeBehindThreads;
        return this;
    }

    public int getWriteBehindThreads() {
        return this.writeBehindThreads;
    }

    public CacheOptions<K, V> writeMode(WriteMode writeMode) {
        this.writeMode = writeMode;
        return this;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public CacheOptions<K, V> loader(CacheLoader<K, V> loader) {
        this.loader = loader;
        return this;
    }

    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheOptions that = (CacheOptions)o;
        return this.writeBehindThreads == that.writeBehindThreads && Objects.equals(this.name, that.name) && Objects.equals(this.loader, that.loader) && Objects.equals(this.writer, that.writer) && this.writeMode == that.writeMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.loader, this.writer, this.writeMode, this.writeBehindThreads});
    }

    public static enum WriteMode {
        WRITE_BEHIND,
        WRITE_THROUGH;

    }
}

