/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.lifecycle;

import cn.sliew.milky.common.lifecycle.LifeCycleListener;
import java.time.Duration;

public interface LifeCycle {
    public State getState();

    public void addLifeCycleListener(LifeCycleListener var1);

    public void removeLifeCycleListener(LifeCycleListener var1);

    public LifeCycleResult initialize();

    public LifeCycleSupportResult supportInitialize();

    public LifeCycleResult start();

    public LifeCycleSupportResult supportStart();

    public boolean isStarted();

    public LifeCycleResult stop();

    public LifeCycleSupportResult supportStop();

    public LifeCycleResult stop(Duration var1);

    public boolean isStopped();

    public static class LifeCycleSupportResult {
        private final boolean support;
        private final String reason;

        private LifeCycleSupportResult(boolean support, String reason) {
            this.support = support;
            this.reason = reason;
        }

        public boolean support() {
            return this.support;
        }

        public String reason() {
            return this.reason;
        }

        public static LifeCycleSupportResult support(String reason) {
            return new LifeCycleSupportResult(true, reason);
        }

        public static LifeCycleSupportResult unsupport(String reason) {
            return new LifeCycleSupportResult(false, reason);
        }
    }

    public static class LifeCycleResult {
        private final boolean status;
        private final Throwable throwable;

        private LifeCycleResult(boolean status, Throwable throwable) {
            this.status = status;
            this.throwable = throwable;
        }

        public boolean isSuccess() {
            return this.status;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public static LifeCycleResult success() {
            return new LifeCycleResult(true, null);
        }

        public static LifeCycleResult failure(Throwable throwable) {
            return new LifeCycleResult(false, throwable);
        }
    }

    public static enum State {
        INITIALIZING,
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

