/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.lettuce;

import cn.sliew.milky.cache.lettuce.LettuceAsyncCommandsWrapper;
import cn.sliew.milky.cache.lettuce.LettuceCommandsWrapper;
import cn.sliew.milky.cache.lettuce.LettuceConnectionFactory;
import cn.sliew.milky.cache.lettuce.ProtostuffCodec;
import cn.sliew.milky.common.exception.Rethrower;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.support.BoundedPoolConfig;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.io.IOException;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class DefaultLettuceConnectionFactory
implements LettuceConnectionFactory {
    private final GenericObjectPoolConfig poolConfig;
    private GenericObjectPool<StatefulRedisConnection<?, ?>> connectionPool;
    private GenericObjectPool<StatefulRedisClusterConnection<?, ?>> clusterConnectionPool;

    public DefaultLettuceConnectionFactory(RedisClient client, BoundedPoolConfig poolConfig) {
        this.poolConfig = this.convert(poolConfig);
        this.connectionPool = ConnectionPoolSupport.createGenericObjectPool(() -> client.connect((RedisCodec)ProtostuffCodec.INSTANCE), (GenericObjectPoolConfig)this.poolConfig);
    }

    public DefaultLettuceConnectionFactory(RedisClusterClient clusterClient, BoundedPoolConfig poolConfig) {
        this.poolConfig = this.convert(poolConfig);
        this.clusterConnectionPool = ConnectionPoolSupport.createGenericObjectPool(() -> clusterClient.connect((RedisCodec)ProtostuffCodec.INSTANCE), (GenericObjectPoolConfig)this.poolConfig);
    }

    @Override
    public LettuceConnectionFactory.LettuceConnection getConnection() {
        try {
            if (this.connectionPool != null) {
                return new LettuceConnectionWrapper((StatefulRedisConnection)this.connectionPool.borrowObject());
            }
            return new LettuceConnectionWrapper((StatefulRedisClusterConnection)this.clusterConnectionPool.borrowObject());
        }
        catch (Exception e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    private void release(StatefulRedisConnection connection) {
        if (this.connectionPool != null) {
            this.connectionPool.returnObject((Object)connection);
        }
    }

    private void release(StatefulRedisClusterConnection clusterConnection) {
        if (this.clusterConnectionPool != null) {
            this.clusterConnectionPool.returnObject((Object)clusterConnection);
        }
    }

    private GenericObjectPoolConfig convert(BoundedPoolConfig poolConfig) {
        GenericObjectPoolConfig target = new GenericObjectPoolConfig();
        if (poolConfig.getMaxTotal() > 0) {
            target.setMaxTotal(poolConfig.getMaxTotal());
        } else {
            target.setMaxTotal(Integer.MAX_VALUE);
        }
        if (poolConfig.getMaxIdle() > 0) {
            target.setMaxIdle(poolConfig.getMaxIdle());
        } else {
            target.setMaxIdle(Integer.MAX_VALUE);
        }
        target.setMinIdle(poolConfig.getMinIdle());
        target.setTestOnBorrow(poolConfig.isTestOnAcquire());
        target.setTestOnCreate(poolConfig.isTestOnCreate());
        target.setTestOnReturn(poolConfig.isTestOnRelease());
        return target;
    }

    private class LettuceConnectionWrapper
    implements LettuceConnectionFactory.LettuceConnection {
        private StatefulRedisConnection connection;
        private StatefulRedisClusterConnection clusterConnection;

        LettuceConnectionWrapper(StatefulRedisConnection connection) {
            this.connection = connection;
        }

        LettuceConnectionWrapper(StatefulRedisClusterConnection clusterConnection) {
            this.clusterConnection = clusterConnection;
        }

        @Override
        public LettuceCommandsWrapper sync() {
            return new LettuceCommandsWrapper(this.connection, this.clusterConnection);
        }

        @Override
        public LettuceAsyncCommandsWrapper async() {
            return null;
        }

        @Override
        public void close() throws IOException {
            if (this.connection != null) {
                DefaultLettuceConnectionFactory.this.release(this.connection);
            }
            if (this.clusterConnection != null) {
                DefaultLettuceConnectionFactory.this.release(this.clusterConnection);
            }
        }
    }
}

