/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.lettuce;

import cn.sliew.milky.cache.CacheOptions;
import cn.sliew.milky.common.check.Ensures;
import io.lettuce.core.RedisURI;
import java.util.List;
import java.util.Objects;

public class LettuceCacheOptions<K, V>
extends CacheOptions<K, V> {
    private RedisURI redisURI;
    private List<RedisURI> clusterRedisURIS;

    public void redisURI(RedisURI redisURI) {
        Ensures.checkNotNull(redisURI, () -> "lettuce redisURI can't be empty");
        this.redisURI = redisURI;
    }

    public RedisURI getRedisURI() {
        return this.redisURI;
    }

    public void clusterRedisURIS(List<RedisURI> clusterRedisURIS) {
        Ensures.notEmpty(clusterRedisURIS, () -> "lettuce clusterRedisURIS can't be empty");
        this.clusterRedisURIS = clusterRedisURIS;
    }

    public List<RedisURI> getClusterRedisURIS() {
        return this.clusterRedisURIS;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LettuceCacheOptions that = (LettuceCacheOptions)o;
        return Objects.equals(this.redisURI, that.redisURI) && Objects.equals(this.clusterRedisURIS, that.clusterRedisURIS);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.redisURI, this.clusterRedisURIS);
    }
}

