/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.ohc;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import java.lang.ref.WeakReference;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheStats;

public class OHCacheMeterBinder
extends CacheMeterBinder {
    private final WeakReference<OHCache> cache;

    public OHCacheMeterBinder(OHCache cache, String cacheName, Iterable<Tag> tags) {
        super((Object)cache, cacheName, tags);
        this.cache = new WeakReference<OHCache>(cache);
    }

    public static OHCache monitor(MeterRegistry registry, OHCache cache, String cacheName, String ... tags) {
        return OHCacheMeterBinder.monitor(registry, cache, cacheName, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public static OHCache monitor(MeterRegistry registry, OHCache cache, String cacheName, Iterable<Tag> tags) {
        new OHCacheMeterBinder(cache, cacheName, tags).bindTo(registry);
        return cache;
    }

    protected Long size() {
        return ((OHCache)this.cache.get()).stats().getSize();
    }

    protected long hitCount() {
        return ((OHCache)this.cache.get()).stats().getHitCount();
    }

    protected Long missCount() {
        return ((OHCache)this.cache.get()).stats().getMissCount();
    }

    protected Long evictionCount() {
        return ((OHCache)this.cache.get()).stats().getEvictionCount();
    }

    protected long putCount() {
        OHCacheStats stats = ((OHCache)this.cache.get()).stats();
        return stats.getPutAddCount() + stats.getPutReplaceCount();
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        FunctionCounter.builder((String)"cache.put", (Object)((OHCache)this.cache.get()).stats(), c -> c.getPutAddCount()).tags(this.getTagsWithCacheName()).tag("result", "add").description("Cache put add count").register(registry);
        FunctionCounter.builder((String)"cache.put", (Object)((OHCache)this.cache.get()).stats(), c -> c.getPutReplaceCount()).tags(this.getTagsWithCacheName()).tag("result", "replace").description("Cache put replace count").register(registry);
        FunctionCounter.builder((String)"cache.put", (Object)((OHCache)this.cache.get()).stats(), c -> c.getPutFailCount()).tags(this.getTagsWithCacheName()).tag("result", "fail").description("Cache put fail count").register(registry);
        FunctionCounter.builder((String)"cache.expire", (Object)((OHCache)this.cache.get()).stats(), c -> c.getExpireCount()).tags(this.getTagsWithCacheName()).description("Cache expire count").register(registry);
        FunctionCounter.builder((String)"cache.remove", (Object)((OHCache)this.cache.get()).stats(), c -> c.getRemoveCount()).tags(this.getTagsWithCacheName()).description("Cache remove count").register(registry);
        FunctionCounter.builder((String)"cache.rehash", (Object)((OHCache)this.cache.get()).stats(), c -> c.getRemoveCount()).tags(this.getTagsWithCacheName()).description("Cache rehash count").register(registry);
        Gauge.builder((String)"cache.offheap.size", (Object)((OHCache)this.cache.get()).stats(), c -> c.getCapacity()).tags(this.getTagsWithCacheName()).tag("offheap", "capacity").description("Cache offheap capacity").register(registry);
        Gauge.builder((String)"cache.offheap.size", (Object)((OHCache)this.cache.get()).stats(), c -> c.getFree()).tags(this.getTagsWithCacheName()).tag("offheap", "free").description("Cache offheap free").register(registry);
        Gauge.builder((String)"cache.offheap.size", (Object)((OHCache)this.cache.get()).stats(), c -> c.getTotalAllocated()).tags(this.getTagsWithCacheName()).tag("offheap", "totalAllocated").description("Cache offheap totalAllocated").register(registry);
        Gauge.builder((String)"cache.lruCompactions", (Object)((OHCache)this.cache.get()).stats(), c -> c.getLruCompactions()).tags(this.getTagsWithCacheName()).description("Cache lruCompactions. OHCache always 0.").register(registry);
    }
}

