/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.ohc;

import cn.sliew.milky.cache.Cache;
import cn.sliew.milky.cache.CacheLoader;
import cn.sliew.milky.cache.ohc.OHCacheMeterBinder;
import cn.sliew.milky.cache.ohc.OhcCacheOptions;
import cn.sliew.milky.cache.ohc.ProtostuffCacheSerializer;
import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;

public class OhcCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(ProtostuffCacheSerializer.class);
    private final OHCache<K, V> ohc;
    private final OhcCacheOptions<K, V> options;

    public OhcCache(OhcCacheOptions<K, V> options) {
        this.options = Ensures.checkNotNull(options, () -> "options can't be null");
        OHCacheBuilder ohCacheBuilder = OHCacheBuilder.newBuilder();
        if (options.getSegmentCount() != null) {
            ohCacheBuilder.segmentCount(options.getSegmentCount().intValue());
        }
        if (options.getHashTableSize() != null) {
            ohCacheBuilder.hashTableSize(options.getHashTableSize().intValue());
        }
        if (options.getCapacity() != null) {
            ohCacheBuilder.capacity(options.getCapacity().longValue());
        }
        if (options.getChunkSize() != null) {
            ohCacheBuilder.chunkSize(options.getChunkSize().intValue());
        }
        ohCacheBuilder.keySerializer(options.getKeySerializer());
        ohCacheBuilder.valueSerializer(options.getValueSerializer());
        if (options.getLoadFactor() != null) {
            ohCacheBuilder.loadFactor(options.getLoadFactor().floatValue());
        }
        if (options.getFixedKeySize() != null && options.getFixedValueSize() != null) {
            ohCacheBuilder.fixedEntrySize(options.getFixedKeySize().intValue(), options.getFixedValueSize().intValue());
        }
        if (options.getMaxEntrySize() != null) {
            ohCacheBuilder.maxEntrySize(options.getMaxEntrySize().longValue());
        }
        if (options.getThrowOOME() != null) {
            ohCacheBuilder.throwOOME(options.getThrowOOME().booleanValue());
        }
        if (options.getHashAlgorighm() != null) {
            ohCacheBuilder.hashMode(options.getHashAlgorighm());
        }
        if (options.getUnlocked() != null) {
            ohCacheBuilder.unlocked(options.getUnlocked().booleanValue());
        }
        if (options.getDefaultTTLmillis() != null) {
            ohCacheBuilder.defaultTTLmillis(options.getDefaultTTLmillis().longValue());
        }
        if (options.getTimeouts() != null) {
            ohCacheBuilder.timeouts(options.getTimeouts().booleanValue());
        }
        if (options.getTimeoutsSlots() != null) {
            ohCacheBuilder.timeoutsSlots(options.getTimeoutsSlots().intValue());
        }
        if (options.getTimeoutsPrecision() != null) {
            ohCacheBuilder.timeoutsPrecision(options.getTimeoutsPrecision().intValue());
        }
        if (options.getTicker() != null) {
            ohCacheBuilder.ticker(options.getTicker());
        }
        if (options.getEviction() != null) {
            ohCacheBuilder.eviction(options.getEviction());
        }
        if (options.getFrequencySketchSize() != null) {
            ohCacheBuilder.frequencySketchSize(options.getFrequencySketchSize().intValue());
        }
        if (options.getEdenSize() != null) {
            ohCacheBuilder.edenSize(options.getEdenSize().doubleValue());
        }
        ohCacheBuilder.executorService(Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors()));
        this.ohc = ohCacheBuilder.build();
    }

    @Override
    public String name() {
        return this.options.getName();
    }

    @Override
    public V get(K key) {
        return (V)this.ohc.get(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.ohc.containsKey(key);
    }

    @Override
    public V computeIfAbsent(K key, CacheLoader<K, V> loader, Duration expire) {
        try {
            return (V)this.ohc.getWithLoader(key, key1 -> loader.load(key1), expire.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void put(K key, V value) {
        this.ohc.put(key, value);
    }

    @Override
    public void put(K key, V value, Duration expire) {
        this.ohc.put(key, value, expire.toMillis() + System.currentTimeMillis());
    }

    @Override
    public void remove(K key) {
        this.ohc.remove(key);
    }

    @Override
    public void removeAll(Iterable<K> keys) {
        this.ohc.removeAll(keys);
    }

    @Override
    public long size() {
        return this.ohc.size();
    }

    @Override
    public boolean supportNullKey() {
        return false;
    }

    @Override
    public boolean supportNullValue() {
        return false;
    }

    @Override
    public Iterator<K> keyIterator() {
        return this.ohc.keyIterator();
    }

    @Override
    public Iterator<K> hotKeyIterator(int n) {
        return this.ohc.hotKeyIterator(n);
    }

    @Override
    public void stats(MeterRegistry registry) {
        OHCacheMeterBinder.monitor(registry, this.ohc, this.name(), new String[0]);
    }

    @Override
    public void clear() {
        this.ohc.clear();
    }

    @Override
    public void destroy() {
        try {
            this.ohc.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }
}

