/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.unit;

import java.math.BigDecimal;

public enum MoneyUnit {
    HAO{

        @Override
        public BigDecimal toHao(BigDecimal size) {
            return size;
        }

        @Override
        public BigDecimal toFen(BigDecimal size) {
            return size.divide(C1.divide(C0));
        }

        @Override
        public BigDecimal toJiao(BigDecimal size) {
            return size.divide(C2.divide(C0));
        }

        @Override
        public BigDecimal toYuan(BigDecimal size) {
            return size.divide(C3.divide(C0));
        }

        @Override
        public String getSuffix() {
            return "\u6beb";
        }
    }
    ,
    FEN{

        @Override
        public BigDecimal toHao(BigDecimal size) {
            return size.multiply(C1.divide(C0));
        }

        @Override
        public BigDecimal toFen(BigDecimal size) {
            return size;
        }

        @Override
        public BigDecimal toJiao(BigDecimal size) {
            return size.divide(C2.divide(C1));
        }

        @Override
        public BigDecimal toYuan(BigDecimal size) {
            return size.divide(C3.divide(C1));
        }

        @Override
        public String getSuffix() {
            return "\u5206";
        }
    }
    ,
    JIAO{

        @Override
        public BigDecimal toHao(BigDecimal size) {
            return size.multiply(C2.divide(C0));
        }

        @Override
        public BigDecimal toFen(BigDecimal size) {
            return size.multiply(C2.divide(C1));
        }

        @Override
        public BigDecimal toJiao(BigDecimal size) {
            return size;
        }

        @Override
        public BigDecimal toYuan(BigDecimal size) {
            return size.divide(C3.divide(C2));
        }

        @Override
        public String getSuffix() {
            return "\u89d2";
        }
    }
    ,
    YUAN{

        @Override
        public BigDecimal toHao(BigDecimal size) {
            return size.multiply(C3.divide(C0));
        }

        @Override
        public BigDecimal toFen(BigDecimal size) {
            return size.multiply(C3.divide(C1));
        }

        @Override
        public BigDecimal toJiao(BigDecimal size) {
            return size.multiply(C3.divide(C2));
        }

        @Override
        public BigDecimal toYuan(BigDecimal size) {
            return size;
        }

        @Override
        public String getSuffix() {
            return "\u5143";
        }
    };

    static final BigDecimal _TEN;
    static final BigDecimal _HUNDRED;
    static final BigDecimal C0;
    static final BigDecimal C1;
    static final BigDecimal C2;
    static final BigDecimal C3;

    public abstract BigDecimal toHao(BigDecimal var1);

    public abstract BigDecimal toFen(BigDecimal var1);

    public abstract BigDecimal toJiao(BigDecimal var1);

    public abstract BigDecimal toYuan(BigDecimal var1);

    public abstract String getSuffix();

    static {
        _TEN = BigDecimal.TEN;
        _HUNDRED = BigDecimal.valueOf(100L);
        C0 = BigDecimal.ONE;
        C1 = C0.multiply(_HUNDRED);
        C2 = C1.multiply(_TEN);
        C3 = C2.multiply(_TEN);
    }
}

