/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.component;

import cn.sliew.milky.common.constant.Attribute;
import cn.sliew.milky.common.constant.AttributeKey;
import cn.sliew.milky.common.constant.DefaultAttributeMap;
import cn.sliew.milky.common.constant.DefaultTagSet;
import cn.sliew.milky.common.constant.Tag;
import cn.sliew.milky.component.Component;
import java.util.Collection;
import java.util.UUID;

public abstract class AbstractComponent
implements Component {
    private final String name;
    private final String identifier;
    private final DefaultAttributeMap attributeMap = new DefaultAttributeMap();
    private final DefaultTagSet tagSet = new DefaultTagSet();

    public AbstractComponent(String name) {
        this.name = name;
        this.identifier = UUID.randomUUID().toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public <T> Collection<Attribute<T>> attrs() {
        return this.attributeMap.attrs();
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.attributeMap.attr(key);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> key) {
        return this.attributeMap.hasAttr(key);
    }

    @Override
    public Collection<Tag> tags() {
        return this.tagSet.tags();
    }

    @Override
    public void tag(Tag tag) {
        this.tagSet.tag(tag);
    }

    @Override
    public boolean hasTag(Tag tag) {
        return this.tagSet.hasTag(tag);
    }
}

