/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.log;

import cn.sliew.milky.log.LocationAwareSlf4JLogger;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import cn.sliew.milky.log.Slf4jLogger;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLoggerFactory
extends LoggerFactory {
    public static final LoggerFactory INSTANCE = new Slf4jLoggerFactory(true);

    Slf4jLoggerFactory(boolean failIfNOP) {
        assert (failIfNOP);
        if (org.slf4j.LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory) {
            throw new NoClassDefFoundError("NOPLoggerFactory not supported");
        }
    }

    @Override
    public Logger newInstance(String name) {
        return Slf4jLoggerFactory.wrapLogger(org.slf4j.LoggerFactory.getLogger((String)name));
    }

    static Logger wrapLogger(org.slf4j.Logger logger) {
        return logger instanceof LocationAwareLogger ? new LocationAwareSlf4JLogger((LocationAwareLogger)logger) : new Slf4jLogger(logger);
    }
}

