/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.primitives;

import cn.sliew.milky.common.primitives.Strings;

public final class Doubles {
    private Doubles() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Failed to parse double value [%s]", value));
        }
    }

    public static double parseDouble(String value, double defaultValue) {
        if (Strings.hasText(value)) {
            return Doubles.parseDouble(value);
        }
        return defaultValue;
    }

    public static Double parseDouble(String value, Double defaultValue) {
        if (Strings.hasText(value)) {
            return Doubles.parseDouble(value);
        }
        return defaultValue;
    }
}

