/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.registry;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.registry.EntryAddedEvent;
import cn.sliew.milky.registry.EntryRemovedEvent;
import cn.sliew.milky.registry.EntryReplacedEvent;
import cn.sliew.milky.registry.InMemoryRegistryStore;
import cn.sliew.milky.registry.Registry;
import cn.sliew.milky.registry.RegistryListener;
import cn.sliew.milky.registry.RegistryStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public abstract class AbstractRegistry<E, C>
implements Registry<E, C> {
    protected final RegistryStore<E> entries = new InMemoryRegistryStore();
    protected final ConcurrentMap<String, C> configurations = new ConcurrentHashMap<String, C>();
    protected final CompositeRegistryListener<E> listeners = new CompositeRegistryListener(Collections.emptyList());

    protected E computeIfAbsent(String name, Supplier<E> supplier) {
        return (E)this.entries.computeIfAbsent(Ensures.checkNotNull(name, () -> "Name must not be null"), (? super String k) -> {
            Object entry = supplier.get();
            this.listeners.onAdded(new EntryAddedEvent(entry));
            return entry;
        });
    }

    @Override
    public Optional<E> find(String name) {
        return this.entries.find(name);
    }

    @Override
    public Optional<E> remove(String name) {
        Optional<E> removedEntry = this.entries.remove(name);
        removedEntry.ifPresent(entry -> this.listeners.onRemoved(new EntryRemovedEvent<Object>(entry)));
        return removedEntry;
    }

    @Override
    public Optional<E> replace(String name, E newEntry) {
        Optional<E> replacedEntry = this.entries.replace(name, newEntry);
        replacedEntry.ifPresent(oldEntry -> this.listeners.onReplaced(new EntryReplacedEvent<Object>(oldEntry, newEntry)));
        return replacedEntry;
    }

    @Override
    public boolean exist(String name) {
        return this.entries.exists(name);
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.values().iterator();
    }

    @Override
    public void addConfiguration(String configName, C configuration) {
        this.configurations.put(configName, configuration);
    }

    @Override
    public Optional<C> getConfiguration(String configName) {
        return Optional.ofNullable(this.configurations.get(configName));
    }

    @Override
    public void registerListener(RegistryListener<E> listener) {
        ((CompositeRegistryListener)this.listeners).register(listener);
    }

    private class CompositeRegistryListener<E>
    implements RegistryListener<E> {
        private final List<RegistryListener<E>> delegates;

        public CompositeRegistryListener(List<RegistryListener<E>> delegates) {
            this.delegates = new ArrayList<RegistryListener<E>>((Collection)Ensures.checkNotNull(delegates));
        }

        private void register(RegistryListener<E> listener) {
            if (this.delegates.contains(listener)) {
                throw new IllegalStateException(String.format("duplicate register for %s", listener));
            }
            this.delegates.add(listener);
        }

        @Override
        public void onAdded(EntryAddedEvent<E> event) {
            this.delegates.forEach(listener -> listener.onAdded(event));
        }

        @Override
        public void onRemoved(EntryRemovedEvent<E> event) {
            this.delegates.forEach(listener -> listener.onRemoved(event));
        }

        @Override
        public void onReplaced(EntryReplacedEvent<E> event) {
            this.delegates.forEach(listener -> listener.onReplaced(event));
        }
    }
}

