/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.util;

import cn.sliew.milky.common.check.Ensures;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ClassUtil {
    private ClassUtil() {
        throw new IllegalStateException("can't do this!");
    }

    public static String nullSafeToString(Class<?> clazz) {
        return clazz == null ? "null" : clazz.getName();
    }

    public static String nullSafeToString(Class<?> ... classes) {
        return ClassUtil.nullSafeToString(Class::getName, classes);
    }

    public static String nullSafeToString(Function<? super Class<?>, ? extends String> mapper, Class<?> ... classes) {
        Ensures.checkNotNull(mapper, () -> "Mapping function must not be null");
        if (classes == null || classes.length == 0) {
            return "";
        }
        return Arrays.stream(classes).map(clazz -> clazz == null ? "null" : (String)mapper.apply((Class<?>)clazz)).collect(Collectors.joining(", "));
    }

    public static ClassLoader getClassLoader() {
        return ClassUtil.getClassLoader(ClassUtil.class);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = clazz.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

