/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.concurrent;

import java.util.concurrent.RejectedExecutionException;

public interface RunnableWrapper
extends Runnable {
    @Override
    default public void run() {
        try {
            this.onBefore();
            this.doRun();
            this.onAfter();
        }
        catch (RejectedExecutionException t) {
            this.onRejection(t);
        }
        catch (Exception t) {
            this.onFailure(t);
        }
        finally {
            this.onFinal();
        }
    }

    public void doRun() throws Exception;

    public void onFailure(Exception var1);

    default public void onRejection(Exception e) {
        this.onFailure(e);
    }

    default public void onBefore() throws Exception {
    }

    default public void onAfter() throws Exception {
    }

    default public void onFinal() {
    }

    default public boolean isForceExecution() {
        return false;
    }
}

