/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.concurrent;

import cn.sliew.milky.common.concurrent.DaemonThreadFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public enum ThreadPoolUtil {

    private static ConcurrentMap<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();

    private static ExecutorService init(String poolName, int poolSize) {
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("Pool-" + poolName, true), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService getOrInitExecutors(String poolName, int poolSize) {
        return executors.computeIfAbsent(poolName, key -> ThreadPoolUtil.init(poolName, poolSize));
    }

    public static void releaseExecutors(String poolName) {
        ExecutorService executorService = (ExecutorService)executors.remove(poolName);
        if (executorService != null) {
            executorService.shutdown();
        }
    }
}

