/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.settings;

import cn.sliew.milky.common.check.Requires;
import cn.sliew.milky.common.settings.Key;
import cn.sliew.milky.common.settings.SettingUpdater;
import cn.sliew.milky.common.settings.Settings;
import cn.sliew.milky.common.settings.Validator;
import cn.sliew.milky.log.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class Setting<T> {
    private final Key key;
    protected final Function<Settings, String> defaultValue;
    private final Optional<Setting<T>> fallbackSetting;
    private final Function<String, T> parser;
    private final Validator<T> validator;

    public Setting(Key key, Function<Settings, String> defaultValue, Setting<T> fallbackSetting, Function<String, T> parser, Validator<T> validator) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.fallbackSetting = Optional.ofNullable(fallbackSetting);
        this.parser = parser;
        this.validator = validator;
    }

    public final String getKey() {
        return this.key.toString();
    }

    public final Key getRawKey() {
        return this.key;
    }

    public T get(Settings settings) {
        return this.get(settings, true);
    }

    private T get(Settings settings, boolean validate) {
        String value = this.getRaw(settings);
        try {
            T parsed = this.parser.apply(value);
            if (validate) {
                Map<Setting<T>, T> map;
                Iterator<Setting<T>> it = this.validator.settings();
                if (it.hasNext()) {
                    map = new HashMap();
                    while (it.hasNext()) {
                        Setting<T> setting = it.next();
                        map.put(setting, setting.get(settings, false));
                    }
                } else {
                    map = Collections.emptyMap();
                }
                this.validator.validate(parsed);
                this.validator.validate(parsed, map);
            }
            return parsed;
        }
        catch (Exception t) {
            throw new IllegalArgumentException("Failed to parse value [" + value + "] for setting [" + this.getKey() + "]", t);
        }
    }

    public final String getRaw(Settings settings) {
        return this.innerGetRaw(settings);
    }

    String innerGetRaw(Settings settings) {
        return settings.get(this.getKey(), this.defaultValue.apply(settings));
    }

    public T getDefault(Settings settings) {
        return this.parser.apply(this.getDefaultRaw(settings));
    }

    public String getDefaultRaw(Settings settings) {
        return this.defaultValue.apply(settings);
    }

    public boolean exists(Settings settings) {
        return settings.keySet().contains(this.getKey());
    }

    public boolean existsOrFallbackExists(Settings settings) {
        return settings.keySet().contains(this.getKey()) || this.fallbackSetting.isPresent() && this.fallbackSetting.get().existsOrFallbackExists(settings);
    }

    public final boolean match(String toTest) {
        return this.key.match(toTest);
    }

    boolean isGroupSetting() {
        return false;
    }

    public SettingUpdater<T> newUpdater(Consumer<T> updater, Consumer<T> validator, Logger logger) {
        return new Updater<T>(this, updater, validator, logger);
    }

    private static final class Updater<T>
    implements SettingUpdater<T> {
        private final Setting<T> setting;
        private final Consumer<T> updater;
        private final Consumer<T> validator;
        private final Logger log;

        public Updater(Setting<T> setting, Consumer<T> updater, Consumer<T> validator, Logger log) {
            this.setting = setting;
            this.updater = updater;
            this.validator = validator;
            this.log = log;
        }

        @Override
        public Setting<T> getSetting() {
            return this.setting;
        }

        @Override
        public boolean hasChanged(Settings current, Settings previous) {
            String newValue = this.setting.getRaw(current);
            String value = this.setting.getRaw(previous);
            Requires.require(!this.setting.isGroupSetting(), () -> "group settings must override this method");
            Requires.require(value != null, () -> "value was null but can't be unless default is null which is invalid");
            return !value.equals(newValue);
        }

        @Override
        public T getValue(Settings current, Settings previous) {
            String newValue = this.setting.getRaw(current);
            String value = this.setting.getRaw(previous);
            try {
                T inst = this.setting.get(current);
                this.validator.accept(inst);
                return inst;
            }
            catch (AssertionError | Exception e) {
                throw new IllegalArgumentException(String.format("illegal value can't update [%s] from [%s] to [%s]", this.setting.getRawKey(), value, newValue), (Throwable)e);
            }
        }

        @Override
        public void apply(T value, Settings current, Settings previous) {
            this.logSettingUpdate(current, previous);
            this.updater.accept(value);
        }

        private void logSettingUpdate(Settings current, Settings previous) {
            if (this.log.isInfoEnabled()) {
                this.log.info("updating [{}] from [{}] to [{}]", this.setting.getRawKey(), this.setting.getRaw(previous), this.setting.getRaw(current));
            }
        }

        public String toString() {
            return String.format("Updater for: %s", this.setting.toString());
        }
    }
}

