/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.dsl;

import cn.sliew.milky.dsl.AlreadyBuiltException;
import cn.sliew.milky.dsl.Builder;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractBuilder<O>
implements Builder<O> {
    private AtomicBoolean started = new AtomicBoolean();
    private O object;

    @Override
    public final O build() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.object = this.doBuild();
            return this.object;
        }
        throw new AlreadyBuiltException("This object has already been started to build");
    }

    public final O getObject() {
        if (!this.started.get()) {
            throw new IllegalStateException("This object has not been started to build");
        }
        return this.object;
    }

    protected abstract O doBuild() throws Exception;
}

