/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.dsl;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.dsl.AbstractBuilder;
import cn.sliew.milky.dsl.AbstractConfigurer;
import cn.sliew.milky.dsl.ConfigurableBuilder;
import cn.sliew.milky.dsl.Configurer;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractConfiguredBuilder<O, B extends ConfigurableBuilder<O, B>>
extends AbstractBuilder<O>
implements ConfigurableBuilder<O, B> {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfiguredBuilder.class);
    private final Map<Class<? extends Configurer<O, B>>, Configurer<O, B>> configurers = new LinkedHashMap<Class<? extends Configurer<O, B>>, Configurer<O, B>>();
    private BuildState buildState = BuildState.UNBUILT;

    public O getOrBuild() {
        if (!this.isUnbuilt()) {
            return this.getObject();
        }
        try {
            return this.build();
        }
        catch (Exception ex) {
            log.debug("Failed to perform build. Returning null", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final O doBuild() throws Exception {
        Map<Class<? extends Configurer<O, B>>, Configurer<O, B>> map = this.configurers;
        synchronized (map) {
            this.buildState = BuildState.INITIALIZING;
            this.beforeInit();
            this.init();
            this.buildState = BuildState.CONFIGURING;
            this.beforeConfigure();
            this.configure();
            this.buildState = BuildState.BUILDING;
            O result = this.performBuild();
            this.buildState = BuildState.BUILT;
            return result;
        }
    }

    protected void beforeInit() throws Exception {
    }

    protected void beforeConfigure() throws Exception {
    }

    protected abstract O performBuild() throws Exception;

    private void init() throws Exception {
        Collection<Configurer<O, B>> configurers = this.getConfigurers();
        for (Configurer<O, AbstractConfiguredBuilder> configurer : configurers) {
            configurer.init(this);
        }
    }

    private void configure() throws Exception {
        Collection<Configurer<O, B>> configurers = this.getConfigurers();
        for (Configurer<O, AbstractConfiguredBuilder> configurer : configurers) {
            configurer.configure(this);
        }
    }

    public <C extends AbstractConfigurer<O, B>> C apply(C configurer) throws Exception {
        configurer.setBuilder((AbstractConfiguredBuilder)this);
        this.add(configurer);
        return configurer;
    }

    public <C extends Configurer<O, B>> C apply(C configurer) throws Exception {
        this.add(configurer);
        return configurer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends Configurer<O, B>> void add(C configurer) {
        Ensures.checkNotNull(configurer, () -> "configurer cannot be null");
        Class<?> clazz = configurer.getClass();
        Map<Class<? extends Configurer<O, B>>, Configurer<O, B>> map = this.configurers;
        synchronized (map) {
            Ensures.checkState(!this.buildState.isConfigured(), () -> "Cannot apply " + configurer + " to already built object");
            this.configurers.put(clazz, configurer);
        }
    }

    @Override
    public <C extends Configurer<O, B>> C getConfigurer(Class<C> clazz) {
        return (C)this.configurers.get(clazz);
    }

    @Override
    public <C extends Configurer<O, B>> C removeConfigurer(Class<C> clazz) {
        return (C)this.configurers.remove(clazz);
    }

    private Collection<Configurer<O, B>> getConfigurers() {
        return this.configurers.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUnbuilt() {
        Map<Class<? extends Configurer<O, B>>, Configurer<O, B>> map = this.configurers;
        synchronized (map) {
            return this.buildState == BuildState.UNBUILT;
        }
    }

    private static enum BuildState {
        UNBUILT(0),
        INITIALIZING(1),
        CONFIGURING(2),
        BUILDING(3),
        BUILT(4);

        private final int order;

        private BuildState(int order) {
            this.order = order;
        }

        public boolean isInitializing() {
            return BuildState.INITIALIZING.order == this.order;
        }

        public boolean isConfigured() {
            return this.order >= BuildState.CONFIGURING.order;
        }
    }
}

