/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.exception;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.exception.Rethrower;
import java.util.Optional;

public class ThrowableCollector<T> {
    private volatile Optional<Throwable> throwableHolder = Optional.empty();

    private ThrowableCollector() {
    }

    public void execute(Executable executable) {
        this.execute(() -> {
            executable.execute();
            return null;
        });
    }

    public Optional<T> execute(ExecutableWithResult<T> executable) {
        try {
            return Optional.ofNullable(executable.execute());
        }
        catch (Throwable t) {
            Rethrower.rethrowIfUnrecoverable(t);
            this.add(t);
            return Optional.empty();
        }
    }

    private void add(Throwable t) {
        Ensures.checkNotNull(t, () -> "Throwable must not be null");
        if (this.throwableHolder.isPresent()) {
            this.throwableHolder.get().addSuppressed(t);
        } else {
            this.throwableHolder = Optional.of(t);
        }
    }

    public Optional<Throwable> getThrowable() {
        return this.throwableHolder;
    }

    public static <T> ThrowableCollector<T> create() {
        return new ThrowableCollector<T>();
    }

    @FunctionalInterface
    public static interface ExecutableWithResult<T> {
        public T execute() throws Throwable;
    }

    @FunctionalInterface
    public static interface Executable {
        public void execute() throws Throwable;
    }
}

