/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.exception;

import cn.sliew.milky.common.check.Ensures;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ThrowableTraceFormater {
    private final List<String> filteredPrefixes;

    public ThrowableTraceFormater() {
        this(Collections.emptyList());
    }

    public ThrowableTraceFormater(List<String> filteredPrefixes) {
        this.filteredPrefixes = filteredPrefixes;
    }

    public static String readStackTrace(Throwable throwable) {
        Ensures.checkNotNull(throwable, () -> "Throwable must not be null");
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public String formatThrowable(Throwable t) {
        return this.formatThrowable(new StringBuilder(), t).toString();
    }

    public StringBuilder formatThrowable(StringBuilder b, Throwable t) {
        b.append(t.toString()).append("\n");
        this.formatStackTrace(b, t.getStackTrace());
        if (t.getCause() != null) {
            b.append("Caused by: ");
            this.formatThrowable(b, t.getCause());
        }
        return b;
    }

    public StringBuilder formatStackTrace(StringBuilder b, StackTraceElement[] stackTrace) {
        return this.formatStackTrace(b, Arrays.asList(stackTrace));
    }

    public String formatStackTrace(StackTraceElement[] stackTrace) {
        return this.formatStackTrace(Arrays.asList(stackTrace));
    }

    public String formatStackTrace(Iterable<StackTraceElement> stackTrace) {
        return this.formatStackTrace(new StringBuilder(), stackTrace).toString();
    }

    public StringBuilder formatStackTrace(StringBuilder b, Iterable<StackTraceElement> stackTrace) {
        HashSet<String> filteredSet = new HashSet<String>();
        for (StackTraceElement e : stackTrace) {
            String stackLine = e.toString();
            String filtered = null;
            for (String prefix : this.filteredPrefixes) {
                if (!stackLine.startsWith(prefix)) continue;
                filtered = prefix;
                break;
            }
            if (filtered != null) {
                if (filteredSet.isEmpty()) {
                    b.append("    [...");
                }
                filteredSet.add(filtered);
                continue;
            }
            this.appendFiltered(b, filteredSet);
            b.append("    ").append(stackLine).append("\n");
        }
        this.appendFiltered(b, filteredSet);
        return b;
    }

    private void appendFiltered(StringBuilder b, Set<String> filteredSet) {
        if (!filteredSet.isEmpty()) {
            boolean first = true;
            for (String prefix : filteredSet) {
                if (!first) {
                    b.append(", ");
                }
                first = false;
                b.append(prefix).append("*");
            }
            b.append("]\n");
            filteredSet.clear();
        }
    }
}

