/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.primitives;

import cn.sliew.milky.common.primitives.Strings;

public final class Floats {
    private Floats() {
        throw new AssertionError((Object)"No instances intended");
    }

    public static float parseFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Failed to parse float value [%s]", value));
        }
    }

    public static float parseFloat(String value, float defaultValue) {
        if (Strings.hasText(value)) {
            return Floats.parseFloat(value);
        }
        return defaultValue;
    }

    public static Float parseFloat(String value, Float defaultValue) {
        if (Strings.hasText(value)) {
            return Float.valueOf(Floats.parseFloat(value));
        }
        return defaultValue;
    }
}

