/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.explain;

import cn.sliew.milky.common.util.StringUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Explanation {
    public static final String DEFAULT_NAME = "default";
    public static final String DEFAULT_DESCRIPTION = "";
    private String name;
    private String description;
    private long cost;
    private Throwable cause;
    private List<Explanation> details = new LinkedList<Explanation>();

    public Explanation() {
        this(DEFAULT_NAME, DEFAULT_DESCRIPTION);
    }

    public Explanation(String name) {
        this(name, DEFAULT_DESCRIPTION);
    }

    public Explanation(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String name() {
        return this.name;
    }

    public Explanation name(String name) {
        this.name = name;
        return this;
    }

    public long cost() {
        return this.cost;
    }

    public Explanation cost(long cost) {
        this.cost = cost;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Explanation description(String description) {
        this.description = description;
        return this;
    }

    public Throwable cause() {
        return this.cause;
    }

    public Explanation cause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public Explanation[] details() {
        return this.details.toArray(new Explanation[0]);
    }

    public Explanation withDetail(Explanation ... details) {
        this.details.addAll(Arrays.asList(details));
        return this;
    }

    private String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name());
        if (StringUtils.isNotBlank(this.description())) {
            sb.append(": ");
            sb.append(this.description());
        }
        if (this.cause() != null) {
            sb.append(" (exception: ");
            sb.append(this.cause());
            sb.append(")");
        }
        if (this.cost() > 0L) {
            sb.append(" -- ");
            sb.append(this.cost());
            sb.append("ms");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int depth) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buffer.append("  ");
        }
        buffer.append(this.summary());
        buffer.append("\n");
        Explanation[] details = this.details();
        for (int i = 0; i < details.length; ++i) {
            buffer.append(details[i].toString(depth + 1));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Explanation that = (Explanation)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.details, that.details);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.details);
    }
}

