/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.parse.placeholder;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.primitives.Strings;
import cn.sliew.milky.log.Logger;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;

public class PropertyPlaceholder {
    private final Logger log;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final Optional<String> valueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;

    public PropertyPlaceholder(Logger log, String placeholderPrefix, String placeholderSuffix) {
        this(log, placeholderPrefix, placeholderSuffix, null, true);
    }

    public PropertyPlaceholder(Logger log, String placeholderPrefix, String placeholderSuffix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        Ensures.checkNotNull(log, () -> "'log' must not be null");
        Ensures.notBlank(placeholderPrefix, () -> "'placeholderPrefix' must not be blank");
        Ensures.notBlank(placeholderSuffix, () -> "'placeholderSuffix' must not be blank");
        this.log = log;
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        this.valueSeparator = Optional.ofNullable(valueSeparator);
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public String replacePlaceholders(String value, final Properties properties) {
        Ensures.checkNotNull(properties, () -> "'properties' must not be null");
        PlaceholderResolver placeholderResolver = new PlaceholderResolver(){

            @Override
            public Optional<String> resolvePlaceholder(String placeholderName) {
                return Optional.ofNullable(properties.getProperty(placeholderName));
            }

            @Override
            public boolean shouldIgnoreMissing(String placeholderName) {
                return false;
            }

            @Override
            public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                return true;
            }
        };
        return this.replacePlaceholders(value, placeholderResolver);
    }

    public String replacePlaceholders(String value, PlaceholderResolver placeholderResolver) {
        Ensures.notBlank(value, () -> "'value' must not be blank");
        return this.parseStringValue(value, placeholderResolver, new HashSet<String>(4));
    }

    protected String parseStringValue(String value, PlaceholderResolver placeholderResolver, Set<String> visitedPlaceholders) {
        int startIndex = value.indexOf(this.placeholderPrefix);
        if (startIndex == -1) {
            return value;
        }
        int offset = 0;
        StringBuilder result = new StringBuilder(value);
        while (startIndex != -1) {
            if (startIndex > 0 && result.charAt(startIndex - 1) == '\\') {
                result.deleteCharAt(startIndex - 1);
                offset = startIndex + this.placeholderPrefix.length();
                startIndex = result.indexOf(this.placeholderPrefix, offset);
                continue;
            }
            offset = startIndex + this.placeholderPrefix.length();
            int endIndex = this.findPlaceholderEndIndex(result, offset);
            if (endIndex != -1) {
                int separatorIndex;
                String placeholder = result.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholder = placeholder;
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                Optional<String> optionalPropVal = placeholderResolver.resolvePlaceholder(placeholder = this.parseStringValue(placeholder, placeholderResolver, visitedPlaceholders));
                if (!optionalPropVal.isPresent() && this.valueSeparator.isPresent() && (separatorIndex = placeholder.indexOf(this.valueSeparator.get())) != -1) {
                    String actualPlaceholder = placeholder.substring(0, separatorIndex);
                    String defaultValue = placeholder.substring(separatorIndex + this.valueSeparator.get().length());
                    optionalPropVal = placeholderResolver.resolvePlaceholder(actualPlaceholder);
                    if (!optionalPropVal.isPresent()) {
                        optionalPropVal = Optional.ofNullable(defaultValue);
                    }
                }
                if (!optionalPropVal.isPresent() && placeholderResolver.shouldIgnoreMissing(placeholder)) {
                    if (placeholderResolver.shouldRemoveMissingPlaceholder(placeholder)) {
                        optionalPropVal = Optional.of(Strings.empty());
                    } else {
                        return value;
                    }
                }
                if (optionalPropVal.isPresent()) {
                    String propertyValue = optionalPropVal.get();
                    propertyValue = this.parseStringValue(propertyValue, placeholderResolver, visitedPlaceholders);
                    result.replace(startIndex, endIndex + this.placeholderSuffix.length(), propertyValue);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Resolved placeholder '" + placeholder + "'");
                    }
                    startIndex = result.indexOf(this.placeholderPrefix, startIndex + propertyValue.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = result.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in value \"" + value + "\"");
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private int findPlaceholderEndIndex(StringBuilder buf, int offset) {
        int withinNestedPlaceholder = 0;
        while (offset < buf.length()) {
            if (Strings.substringMatch(buf, offset, this.placeholderSuffix)) {
                if (offset > 0 && buf.charAt(offset - 1) == '\\') {
                    buf.deleteCharAt(offset - 1);
                    offset = offset - 1 + this.placeholderSuffix.length();
                    continue;
                }
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    offset += this.placeholderSuffix.length();
                    continue;
                }
                return offset;
            }
            if (Strings.substringMatch(buf, offset, this.placeholderPrefix)) {
                ++withinNestedPlaceholder;
                offset += this.placeholderPrefix.length();
                continue;
            }
            ++offset;
        }
        return -1;
    }

    public static interface PlaceholderResolver {
        public Optional<String> resolvePlaceholder(String var1);

        public boolean shouldIgnoreMissing(String var1);

        public boolean shouldRemoveMissingPlaceholder(String var1);
    }
}

