/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.recycler;

import cn.sliew.milky.common.recycler.DequeRecycler;
import cn.sliew.milky.common.recycler.Source;
import cn.sliew.milky.common.recycler.Value;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentDequeRecycler<T>
extends DequeRecycler<T> {
    final AtomicInteger size = new AtomicInteger();

    public ConcurrentDequeRecycler(Source<T> source, int maxSize) {
        super(source, new ConcurrentLinkedDeque(), maxSize);
    }

    @Override
    public Value<T> obtain() {
        Value v = super.obtain();
        if (v.isRecycled()) {
            this.size.decrementAndGet();
        }
        return v;
    }

    @Override
    protected boolean beforeRelease() {
        return this.size.incrementAndGet() <= this.maxSize;
    }

    @Override
    protected void afterRelease(boolean recycled) {
        if (!recycled) {
            this.size.decrementAndGet();
        }
    }
}

