/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.event.reflection;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.util.ReflectUtil;
import cn.sliew.milky.event.Event;
import cn.sliew.milky.event.EventBus;
import cn.sliew.milky.event.EventListener;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class DefaultEventBus
implements EventBus {
    private final ConcurrentMap<Class, List<EventListener>> eventRepository = new ConcurrentHashMap<Class, List<EventListener>>(2);
    ExecutorService defaultExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() + 1, Runtime.getRuntime().availableProcessors() + 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(126));

    @Override
    public Executor getExecutor() {
        return this.defaultExecutor;
    }

    @Override
    public void fire(Event event) {
        List<EventListener> eventListeners = this.findListener(event.getClass());
        eventListeners.stream().forEach(eventListener -> CompletableFuture.runAsync(() -> eventListener.execute(event), this.getExecutor()));
    }

    @Override
    public <E extends Event> void register(EventListener<E> listener) {
        Ensures.checkNotNull(listener, () -> "event listener null");
        Optional<Class<? extends Event>> classOptional = this.determinateEventType(listener);
        Class<Event> eventClazz = classOptional.orElse(Event.class);
        this.register(eventClazz, listener);
    }

    @Override
    public void register(Class<? extends Event> clazz, EventListener listener) {
        Ensures.checkNotNull(clazz, () -> "clazz null");
        Ensures.checkNotNull(listener, () -> "event listener null");
        List<EventListener> eventListeners = this.findListener(clazz);
        if (eventListeners.contains(listener)) {
            throw new IllegalStateException("can't register twice!");
        }
        eventListeners.add(listener);
    }

    private List<EventListener> findListener(Class<? extends Event> eventClass) {
        return this.eventRepository.computeIfAbsent(eventClass, key -> new LinkedList());
    }

    private Optional<Class<? extends Event>> determinateEventType(EventListener<?> listener) {
        return this.determinateEventType(listener.getClass());
    }

    private Optional<Class<? extends Event>> determinateEventType(Class<?> listenerClass) {
        Optional<Class<? extends Event>> eventType = Optional.empty();
        if (listenerClass != null && EventListener.class.isAssignableFrom(listenerClass)) {
            eventType = ReflectUtil.findParameterizedTypes(listenerClass).stream().map(this::determinateEventType).filter(Optional::isPresent).findAny().orElse(this.determinateEventType(listenerClass.getSuperclass()));
        }
        return eventType;
    }

    private Optional<Class<? extends Event>> determinateEventType(ParameterizedType parameterizedType) {
        Optional<Type> optionalType;
        Type rawType = parameterizedType.getRawType();
        if (rawType instanceof Class && EventListener.class.isAssignableFrom((Class)rawType) && (optionalType = Stream.of(parameterizedType.getActualTypeArguments()).filter(typeArgument -> typeArgument instanceof Class && Event.class.isAssignableFrom((Class)typeArgument)).findFirst()).isPresent()) {
            return Optional.of((Class)optionalType.get());
        }
        return Optional.empty();
    }
}

