/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.environment;

import cn.sliew.milky.common.environment.AbstractPropertyResolver;
import cn.sliew.milky.common.environment.PropertySource;
import cn.sliew.milky.common.environment.PropertySourceIterable;
import java.util.Optional;
import java.util.function.Function;

public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final Optional<PropertySourceIterable> propertySources;

    public PropertySourcesPropertyResolver(PropertySourceIterable propertySources) {
        this.propertySources = Optional.ofNullable(propertySources);
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.propertySources.isPresent()) {
            return this.propertySources.get().stream().filter(propertySource -> propertySource.containsProperty(key)).findAny().isPresent();
        }
        return false;
    }

    @Override
    public Optional<String> getProperty(String key) {
        return Optional.ofNullable(this.getProperty(key, Object::toString, false));
    }

    @Override
    public <R, T> Optional<T> getProperty(String key, Function<R, T> mappingFunction) {
        return Optional.ofNullable(this.getProperty(key, mappingFunction, true));
    }

    @Override
    protected Optional<String> getPropertyAsRawString(String key) {
        return Optional.ofNullable(this.getProperty(key, Object::toString, false));
    }

    protected <R, T> T getProperty(String key, Function<R, T> mappingFunction, boolean resolveNestedPlaceholders) {
        if (this.propertySources.isPresent()) {
            for (PropertySource propertySource : this.propertySources.get()) {
                Object value;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Searching for key '" + key + "' in PropertySource '" + propertySource.getName() + "'");
                }
                if ((value = propertySource.getProperty(key)) == null) continue;
                if (resolveNestedPlaceholders && value instanceof String) {
                    value = this.resolveNestedPlaceholders((String)value);
                }
                this.logKeyFound(key, propertySource, value);
                return (T)(mappingFunction == null ? value : mappingFunction.apply(value));
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Could not find key '" + key + "' in any property source");
        }
        return null;
    }

    protected void logKeyFound(String key, PropertySource<?> propertySource, Object value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found key '" + key + "' in PropertySource '" + propertySource.getName() + "' with value of type " + value.getClass().getSimpleName());
        }
    }
}

